<?php

abstract class Waindigo_Listener_ControllerPreDispatch
{
	protected static $_checkForUpdates = null;
	protected static $_upgradeAddOns = array();
	protected static $_installAddOns = array(); /* Deprecated. */

	protected static $_checkForCopyright = null;
	protected static $_showCopyright = false;

	/**
	 * Standard approach to caching other model objects for the lifetime of the model.
	 *
	 * @var array
	 */
	protected $_modelCache = array();

	/**
	* @var XenForo_Controller
	*/
	protected static $_controller = null;
	protected static $_action = '';

	/**
	 * @param XenForo_Dependencies_Abstract $dependencies
	 * @param array $data
	 */
	public function __construct(XenForo_Controller $controller, $action)
	{
		if (is_null(self::$_controller)) {
		    self::$_controller = $controller;
		}
		if (!self::$_action) {
		    self::$_action = $action;
		}
	} /* END Waindigo_Listener_ControllerPreDispatch::__construct */

	/**
	 * Called before attempting to dispatch the request in a specific
	 * controller. The visitor object is available at this point.
	 *
	 * @param XenForo_Controller $controller - the controller instance. From
	 * this, you can inspect the request, response, etc.
	 * @param string $action - the specific action that will be executed in
	 * this controller.
	 */
	public static function controllerPreDispatch(XenForo_Controller $controller, $action)
	{
	    // This only works on PHP 5.3+, so method should be overridden for now
	    $class = get_called_class();
	    $controllerPreDispatch = new $class($controller, $action);
	    $extend = $controllerPreDispatch->run();
	}

	public function run()
	{
		$cpdListeners = XenForo_CodeEvent::getEventListeners('controller_pre_dispatch');

		$lastListener = end($cpdListeners);
		if ($lastListener[0] == get_class($this) && !isset(self::$_checkForCopyright)) {
			self::$_checkForCopyright = true;
			$this->_removeUnwantedCopyrightNotice();
		}

		$firstListener = reset($cpdListeners);
	    if ($firstListener[0] == get_class($this) && !isset(self::$_checkForUpdates)) {
    		self::$_checkForUpdates = true;
   	    	$lastXMLUploadDate = $this->_getLastXmlUploadDate();

   	    	$addOns = array();

   	    	try {
       	    	/* @var $dir Directory */
    	    	$dir = dir(XenForo_Application::getInstance()->getRootDir() . '/install/data/');

    	    	while ($entry=$dir->read()) {
    				if (strlen($entry) > strlen('addon-.xml') && substr($entry, 0, strlen('addon-')) == 'addon-') {
    					if (filemtime(XenForo_Application::getInstance()->getRootDir() . '/install/data/' . $entry) > $lastXMLUploadDate) {
    						$addOns[] = substr($entry, strlen('addon-'), strlen($entry) - strlen('addon-.xml'));
    					}
    				}
    	    	}
	    	} catch (Exception $e) {
	    	    // do nothing
	    	}

	    	if ($this->_checkAddOnsNeedUpgrading($addOns)) {
	    	    $upgradeAddOns = $this->getUpgradeAddOns();
	    		if (!empty($upgradeAddOns)) {
	    		    XenForo_Application::get('options')->set('boardActive', false);
	    		    if (!XenForo_Visitor::getInstance()->get('is_admin')) {
	    		        try {
    	    		        self::$_controller->preDispatch(self::$_action);
	    		        } catch (XenForo_ControllerResponse_Exception $exception) {
                            $controllerResponse = $exception->getControllerResponse();
                            if (get_class($controllerResponse) == 'XenForo_ControllerResponse_Message') {
                                $controllerResponse->message = new XenForo_Phrase('board_currently_being_upgraded');
                            }
                            throw $exception;
	    		        }
	    		    }
	    		}
	    	}
	    	if (is_subclass_of(self::$_controller, 'XenForo_ControllerAdmin_Abstract')) {
	    	    $controllerName = self::$_controller->getRequest()->getParam('_controllerName');
	    	    $action = self::$_controller->getRequest()->getParam('_action');
	    	    if ($controllerName == 'XenForo_ControllerAdmin_AddOn' && $action == 'UpgradeAllFromXml') {
    	            $this->_upgradeAddOns();
	    	    }
	    	}
    	}
	} /* END Waindigo_Listener_ControllerPreDispatch::run */

	protected function _run()
	{
		try {
			return $this->run();
		} catch (Exception $e) {
			// do nothing
		}
	} /* END Waindigo_Listener_ControllerPreDispatch::_run */

	/**
	 * @param string $addOnId
	 * @param string|null $codeEvent
	 */
	public static function isAddOnEnabled($addOnId, $codeEvent = '')
	{
	    if (!$codeEvent) {
	        $codeEvents = array(
                'container_admin_params',
                'container_public_params',
                'controller_post_dispatch',
                'controller_pre_dispatch',
                'criteria_page',
                'criteria_user',
                'file_health_check',
                'front_controller_post_view',
                'front_controller_pre_dispatch',
                'front_controller_pre_route',
                'front_controller_pre_view',
                'init_dependencies',
                'init_router_public',
                'load_class_bb_code',
                'load_class_controller',
                'load_class_datawriter',
                'load_class_importer',
                'load_class_mail',
                'load_class_model',
                'load_class_route_prefix',
                'load_class_search_data',
                'load_class_view',
                'navigation_tabs',
                'option_captcha_render',
                'search_source_create',
                'template_create',
                'template_hook',
                'template_post_render',
                'visitor_setup',
                'load_class_installer_waindigo',
                'load_class_pdf_waindigo',
                'load_class_reward_handler',
	        );
	    } else {
	        $codeEvents = array($codeEvent);
	    }

	    foreach ($codeEvents as $codeEvent) {
	        $listeners = XenForo_CodeEvent::getEventListeners($codeEvent);
	        if (!empty($listeners)) {
	            foreach ($listeners as $listener) {
	                if (strlen($listener[0]) > strlen($addOnId) && substr($listener[0], 0, strlen($addOnId)) == $addOnId) {
	                    return true;
	                }
	            }
	        }
	    }
	    return false;
	} /* END Waindigo_Listener_ControllerPreDispatch::isAddOnEnabled */

	/**
	 * Gets the specified model object from the cache. If it does not exist,
	 * it will be instantiated.
	 *
	 * @param string $class Name of the class to load
	 *
	 * @return XenForo_Model
	 */
	public function getModelFromCache($class)
	{
		if (!isset($this->_modelCache[$class])) {
			$this->_modelCache[$class] = XenForo_Model::create($class);
		}

		return $this->_modelCache[$class];
	} /* END Waindigo_Listener_ControllerPreDispatch::getModelFromCache */

	/**
	 * @param array $addOns
	 */
	protected function _checkAddOnsNeedUpgrading(array $addOns)
	{
	    if (empty($addOns)) {
	        return false;
	    }

		/* @var $addOnModel XenForo_Model_AddOn */
		$addOnModel = XenForo_Model::create('XenForo_Model_AddOn');

		$allAddOns = $addOnModel->getAllAddOns();

		$lastXmlUploadDate = $this->_getLastXmlUploadDate();
		foreach ($addOns as $addOnId) {
			if (isset($allAddOns[$addOnId])) {
				$addOn = $allAddOns[$addOnId];

				$addOnXML = new SimpleXMLElement(file_get_contents(XenForo_Application::getInstance()->getRootDir() . '/install/data/addon-'.$addOnId.'.xml'));
				$versionId = (string)$addOnXML->attributes()->version_id;
				if ($versionId > $addOn['version_id']) {
					self::$_upgradeAddOns[$addOnId] = $addOn;
				} else {
				    $xmlUploadDate = filemtime(XenForo_Application::getInstance()->getRootDir() . '/install/data/addon-'.$addOnId.'.xml');
				    if ($xmlUploadDate > $lastXmlUploadDate) {
				        $lastXmlUploadDate = $xmlUploadDate;
				    }
				}
			}
		}

		if (is_subclass_of(self::$_controller, 'XenForo_ControllerAdmin_Abstract')) {
			eval('class Waindigo_Listener_ControllerPreDispatch_TemplatePostRender
{
	public static function templatePostRender($templateName, &$content, array &$containerData, XenForo_Template_Abstract $template)
	{
		if ($templateName == "PAGE_CONTAINER") {
			$upgradeAddOns = Waindigo_Listener_ControllerPreDispatch::getUpgradeAddOns();
			if (!empty($upgradeAddOns)) {
			    $params = $template->getParams();
			    if (!$params[\'showUpgradePendingNotice\']) {
    			    $pattern = \'#<noscript><p class="importantMessage">.*</p></noscript>#U\';
                    $replacement = \'<p class="importantMessage">\' . new XenForo_Phrase(\'forum_is_currently_closed_only_admins_may_access\') . \'<br /><a href="\'.XenForo_Link::buildAdminLink(\'add-ons/upgrade-all-from-xml\').\'">\' . new XenForo_Phrase(\'upgrade_add_on\') . \'</a></p>\';
    			    $content = preg_replace($pattern, \'${1}\' . $replacement, $content);
			    }
			}
		}
	}
}');
    		$tprListeners = XenForo_CodeEvent::getEventListeners('template_post_render');
    		if (!$tprListeners) {
    		    $tprListeners = array();
    		}
		    $tprListeners = array_merge($tprListeners, array(array('Waindigo_Listener_ControllerPreDispatch_TemplatePostRender', 'templatePostRender')));
    		XenForo_CodeEvent::setListeners(array('template_post_render' => $tprListeners));
		}

		if (empty(self::$_upgradeAddOns)) {
    	    $this->_setLastXmlUploadDate($lastXmlUploadDate);
		    return false;
		}

		return true;
	} /* END Waindigo_Listener_ControllerPreDispatch::_checkAddOnsNeedUpgrading */

	public static function getUpgradeAddOns()
	{
		return self::$_upgradeAddOns;
	} /* END Waindigo_Listener_ControllerPreDispatch::getUpgradeAddOns */

	/**
	 * Deprecated.
	 * @deprecated
	 */
	public static function getInstallAddOns()
	{
		return array();
	} /* END Waindigo_Listener_ControllerPreDispatch::getInstallAddOns */

	/**
	 * Deprecated.
	 * @deprecated
	 * @param string $action
	 */
	protected function _upgradeOrInstallAddOns($action)
	{
	    return $this->_upgradeAddOns();
	} /* END Waindigo_Listener_ControllerPreDispatch::_upgradeOrInstallAddOns */

	/**
	 * @param string $action
	 */
	protected function _upgradeAddOns()
	{
		$template = new XenForo_Template_Admin('PAGE_CONTAINER_SIMPLE', array(
			'jQuerySource' => XenForo_Dependencies_Abstract::getJquerySource(),
			'xenOptions' => XenForo_Application::get('options')->getOptions(),
			'_styleModifiedDate' => XenForo_Application::get('adminStyleModifiedDate'),
		));
		$template->setLanguageId(1);

		$template->setParam('title', 'Upgrading Add-ons...');
		$addOns = array_keys(self::getUpgradeAddOns());

		$addOnModel = XenForo_Model::create('XenForo_Model_AddOn');
		$nextAddOnId = '';
		if (count($addOns)) {
			$next = self::$_controller->getInput()->filterSingle('next', XenForo_Input::STRING);
			if ($next) {
				$addOn = $next;
			} else {
				$addOn = reset($addOns);
			}
			for ($i=0; $i<count($addOns); $i++) {
				if ($addOns[$i] != $addOn) {
					unset($addOns[$i]);
					continue;
				}
				break;
			}
			$fileName = XenForo_Application::getInstance()->getRootDir() . '/install/data/addon-'.$addOn.'.xml';
			try {
				$caches = $addOnModel->installAddOnXmlFromFile($fileName, $addOn);
				$template->setParam('contents', '<form action="'.XenForo_Link::buildAdminLink('add-ons/upgrade-all-from-xml').'" class="xenForm formOverlay CacheRebuild" method="post">
					<p id="ProgressText">Upgrading... <span class="RebuildMessage"></span> <span class="DetailedMessage"></span></p>
					<p id="ErrorText" style="display: none">An error occurred or the request was stopped.</p>
					<input type="submit" class="button" value="Continue Upgrading" />
					<input type="hidden" name="_xfToken" value="'.XenForo_Visitor::getInstance()->get('csrf_token_page').'" />
					</form>');
			} catch (Exception $e) {
				if (count($addOns) == 1) {
					$template->setParam('contents', 'Upgrade error (' . $addOn . '). Please use the <a href="' . XenForo_Link::buildAdminLink('add-ons/upgrade', array('addon_id' => $addOn)) . '">standard upgrade tool</a> and report any error messages to the developer.');
				} else {
					unset($addOns[array_search($addOn, $addOns)]);
					$nextAddOnId = reset($addOns);
					$template->setParam('contents', '<form action="'.XenForo_Link::buildAdminLink('add-ons/upgrade-all-from-xml').'" class="xenForm formOverlay CacheRebuild" method="post">
						<p id="ProgressText">Upgrading... <span class="RebuildMessage"></span> <span class="DetailedMessage"></span></p>
						<p id="ErrorText" style="display: none">An error occurred or the request was stopped.</p>
						<input type="submit" class="button" value="Continue Upgrading" />
						<input type="hidden" name="next" value="'.$nextAddOnId.'" />
						<input type="hidden" name="_xfToken" value="'.XenForo_Visitor::getInstance()->get('csrf_token_page').'" />
						</form>');
				}
			}
		} else {
			$caches = $addOnModel->rebuildAddOnCaches();
		}

		if (!count($addOns) && isset($caches)) {
			if (self::$_controller->getRouteMatch()->getResponseType() == 'json') {
				header('Content-Type: application/json; charset=UTF-8');
				echo json_encode(array('_redirectTarget' => XenForo_Link::buildAdminLink('index')));
			} else {
				header('Location: '.XenForo_Link::buildAdminLink('index'));
			}
		} else if (count($addOns) == 1 && isset($caches)) {
			if (self::$_controller->getRouteMatch()->getResponseType() == 'json') {
				header('Content-Type: application/json; charset=UTF-8');
				echo json_encode(array(
					'_redirectTarget' => XenForo_Link::buildAdminLink('tools/cache-rebuild', null,
							array('caches' => json_encode($caches)))
				));
			} else {
				header('Location: '.XenForo_Link::buildAdminLink('tools/cache-rebuild', null,
					array('caches' => json_encode($caches))));
			}
		} else {
			if (self::$_controller->getRouteMatch()->getResponseType() == 'json') {
				echo json_encode(array(	'_redirectTarget' => XenForo_Link::buildAdminLink('add-ons/upgrade-all-from-xml', array(), array('next' => $nextAddOnId))));
			} else {
				$output = $template->render();
				$output = str_replace("<!--XenForo_Require:JS-->", '<script src="js/xenforo/cache_rebuild.js"></script>', $output);
				echo $output;
			}
		}
		exit();
	} /* END Waindigo_Listener_ControllerPreDispatch::_upgradeAddOns */

	/**
	 * This is to ensure copyright notices don't display on every page if all add-ons
	 * are newer than 15 September 2012 (unless explicitly set).
	 */
	protected function _removeUnwantedCopyrightNotice()
	{
		if (self::$_showCopyright) {
		    return;
		}

		$className = get_class(self::$_controller);
		if (strlen($className) > strlen('Waindigo_') && substr($className, 0, strlen('Waindigo')) == 'Waindigo') {
			return;
		}

		$addOns = array();
		$rootDir = XenForo_Autoloader::getInstance()->getRootDir();

		$thListeners = XenForo_CodeEvent::getEventListeners('template_hook');
		if (!empty($thListeners)) {
			$templateHookVersion = 0;
			foreach ($thListeners as $templateHook) {
				if (strlen($templateHook[0]) > strlen('Waindigo_') && substr($templateHook[0], 0, strlen('Waindigo_')) == 'Waindigo_') {
					if (!$templateHookVersion) {
					    $handle = opendir($rootDir . '/Waindigo/Listener/TemplateHook');
						if ($handle) {
							while (false !== ($entry = readdir($handle))) {
								if (intval($entry) > $templateHookVersion) {
									$templateHookVersion = intval($entry);
								}
							}
						}
					}
					if ($templateHookVersion < '20120715') {
					    return;
					}
					$addOns[] = substr($templateHook[0], 0, strlen($templateHook[0])-strlen('_Listener_TemplateHook'));
				}
			}
		}

		$tprListeners = XenForo_CodeEvent::getEventListeners('template_post_render');
		if (!empty($tprListeners)) {
			$templatePostRenderVersion = 0;
			foreach ($tprListeners as $templatePostRender) {
				if (strlen($templatePostRender[0]) > strlen('Waindigo_') && substr($templatePostRender[0], 0, strlen('Waindigo_')) == 'Waindigo_') {
					if (!$templatePostRenderVersion) {
						if ($handle = opendir($rootDir . '/Waindigo/Listener/TemplatePostRender')) {
							while (false !== ($entry = readdir($handle))) {
								if (intval($entry) > $templatePostRenderVersion) {
									$templatePostRenderVersion = intval($entry);
								}
							}
						}
					}
					$addOnId = substr($templatePostRender[0], 0, strlen($templatePostRender[0])-strlen('_Listener_TemplatePostRender'));
					if (in_array($addOnId, $addOns)) {
					    continue;
					}
					if ($templatePostRenderVersion < '20120715') {
					    return;
					}
					$addOns[] = $addOnId;
				}
			}
		}

		$lccListeners = XenForo_CodeEvent::getEventListeners('load_class_controller');
		if (!empty($lccListeners)) {
			$loadClassVersion = 0;
			foreach ($lccListeners as $loadClassController) {
				if (strlen($loadClassController[0]) > strlen('Waindigo_') && substr($loadClassController[0], 0, strlen('Waindigo_')) == 'Waindigo_') {
					if (!$loadClassVersion) {
						if ($handle = opendir($rootDir . '/Waindigo/Listener/LoadClass')) {
							while (false !== ($entry = readdir($handle))) {
								if (intval($entry) > $loadClassVersion) {
									$loadClassVersion = intval($entry);
								}
							}
						}
					}
					$addOnId = substr($loadClassController[0], 0, strlen($loadClassController[0])-strlen('_Listener_LoadClassController'));
					if ($loadClassVersion >= '20121018') {
						$loadClassController = Waindigo_Listener_LoadClass::create($loadClassController[0]);
						if (method_exists($loadClassController, 'getExtendedClass')) {
    						$extendedClasses = $loadClassController->getExtendedClasses();
    						if (in_array(get_class(self::$_controller), $extendedClasses)) {
    						    return;
    						}
						}
					}
					if (!in_array($addOnId, $addOns)) {
					    $addOns[] = $addOnId;
					}
				}
			}
		}

		$cpdListeners = XenForo_CodeEvent::getEventListeners('controller_pre_dispatch');
		foreach ($cpdListeners as $controllerPreDispatch) {
			if (strlen($controllerPreDispatch[0]) > strlen('Waindigo_') && substr($controllerPreDispatch[0], 0, strlen('Waindigo_')) == 'Waindigo_') {
				$addOnId = substr($controllerPreDispatch[0], 0, strlen($controllerPreDispatch[0])-strlen('_Listener_ControllerPreDispatch'));
				$addOnKey = array_search($addOnId, $addOns);
				if ($addOnKey !== FALSE) {
				    unset($addOns[$addOnKey]);
				}
			}
		}

		if (empty($addOns)) {
			if (method_exists('Waindigo_Listener_Template', 'setCopyrightNotice')) {
				Waindigo_Listener_Template::setCopyrightNotice(true);
			} else {
				eval('class ' . $addOnId . '_Listener_Template extends Waindigo_Listener_Template
{
	public static function setCopyrightNotice($copyrightNotice)
	{
		self::$_copyrightNotice = $copyrightNotice;
	}
}');
				call_user_func(array($addOnId . '_Listener_Template', 'setCopyrightNotice'), true);
			}
		}
	} /* END Waindigo_Listener_ControllerPreDispatch::_removeUnwantedCopyrightNotice */

	protected function _getLastXmlUploadDate()
	{
	    /* @var $options XenForo_Options */
	    $options = XenForo_Application::get('options');
	    return $options->waindigo_lastXmlUploadDate;
	} /* END Waindigo_Listener_ControllerPreDispatch::_getLastXmlUploadDate */

	/**
	 * @param integer $lastXmlUploadDate
	 */
	protected function _setLastXmlUploadDate($lastXmlUploadDate)
	{
	    /* @var $optionModel XenForo_Model_Option */
	    $optionModel = XenForo_Model::create('XenForo_Model_Option');

	    if ($lastXmlUploadDate > $this->_getLastXmlUploadDate()) {
    	    $dw = XenForo_DataWriter::create('XenForo_DataWriter_Option', XenForo_DataWriter::ERROR_SILENT);
    	    if ($this->_getLastXmlUploadDate()) {
    	        $dw->setExistingData('waindigo_lastXmlUploadDate');
    	    }
    	    $dw->set('option_id', 'waindigo_lastXmlUploadDate');
    	    $dw->setOption(XenForo_DataWriter_Option::OPTION_REBUILD_CACHE, true);
    	    $dw->set('option_value', $lastXmlUploadDate);
    	    $dw->set('edit_format', 'spinbox');
    	    $dw->set('data_type', 'positive_integer');
    	    $dw->set('addon_id', 'XenForo');
    	    $dw->save();
	    }
	} /* END Waindigo_Listener_ControllerPreDispatch::_setLastXmlUploadDate */
}