<?php

class Waindigo_LastPostAvatar_Listener_TemplateHook extends Waindigo_Listener_TemplateHook
{
	public function run()
	{
		switch ($this->_hookName) {
			case 'thread_list_threads':
				$this->_threadListThreads();
				break;
			case 'thread_list_stickies':
				$this->_threadListStickies();
				break;
			case 'waindigo_thread_list_item_thread_thumbs':
				$this->_threadListItem();
				break;
		}
		return parent::run();
	} /* END Waindigo_LastPostAvatar_Listener_TemplateHook::run */

	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		$templateHook = new Waindigo_LastPostAvatar_Listener_TemplateHook($hookName, $contents, $hookParams, $template);
		$contents = $templateHook->run();
	} /* END Waindigo_LastPostAvatar_Listener_TemplateHook::templateHook */

	protected function _threadListThreads()
	{
		$this->_threadListAnyThreads('threads');
	} /* END Waindigo_LastPostAvatar_Listener_TemplateHook::_threadListThreads */

	protected function _threadListStickies()
	{
		$this->_threadListAnyThreads('stickyThreads');
	} /* END Waindigo_LastPostAvatar_Listener_TemplateHook::_threadListStickies */

	protected function _threadListItem($viewParams=null)
	{
		if (!$viewParams) {
			$viewParams = $this->_fetchViewParams();
		}
		if ($viewParams['thread']['discussion_state'] != 'deleted' && $viewParams['thread']['discussion_type'] != 'redirect') {
			$pattern = '#(<li id="thread-' . $viewParams['thread']['thread_id'] . '".*<dl class="lastPostInfo">)(.*</dl>.*</li>)#Us';
	        $replacement = '$1' . $this->_render('waindigo_thread_list_item_lastpostavatar', $viewParams) . '$2';
	        $this->_contents = preg_replace($pattern, $replacement, $this->_contents);
		}
	} /* END Waindigo_LastPostAvatar_Listener_TemplateHook::_threadListItem */

	protected function _threadListAnyThreads($threadType)
	{
		$viewParams = $this->_fetchViewParams();
		if (!isset($viewParams[$threadType])) {
		    return;
		}
		foreach ($viewParams[$threadType] as $viewParams['thread']) {
			$this->_threadListItem($viewParams);
		}
	} /* END Waindigo_LastPostAvatar_Listener_TemplateHook::_threadListAnyThreads */
}