<?php

class Waindigo_LastPostAvatar_Listener_TemplateCreate extends Waindigo_Listener_TemplateCreate {

	public function run()
	{
		switch ($this->_templateName) {
			case 'forum_view':
				$this->_forumView();
				break;
			case 'forum_list':
				$this->_forumList();
				break;
			case 'waindigo_social_category_view_socialgroups':
			    $this->_socialCategoryView();
			    break;
		}
		return parent::run();
	} /* END Waindigo_LastPostAvatar_Listener_TemplateCreate::run */

	public static function templateCreate(&$templateName, array &$params, XenForo_Template_Abstract $template)
	{
		$templateCreate = new Waindigo_LastPostAvatar_Listener_TemplateCreate($templateName, $params, $template);
		$templateCreate->run();
	} /* END Waindigo_LastPostAvatar_Listener_TemplateCreate::templateCreate */

	protected function _forumView()
	{
		$this->_preloadTemplate('waindigo_thread_list_item_lastpostavatar');
		$this->_forumList();
	} /* END Waindigo_LastPostAvatar_Listener_TemplateCreate::_forumView */

	protected function _forumList()
	{
		$this->_preloadTemplate('waindigo_node_forum_avatar_lastpostavatar');
		$this->_preloadTemplate('waindigo_node_category_avatar_lastpostavatar');
		$this->_preloadTemplate('waindigo_node_library_avatar_lastpostavatar');
	} /* END Waindigo_LastPostAvatar_Listener_TemplateCreate::_forumList */

	protected function _socialCategoryView()
	{
	    $this->_preloadTemplate('waindigo_node_forum_avatar_lastpostavatar');
	} /* END Waindigo_LastPostAvatar_Listener_TemplateCreate::_socialCategoryView */
}