<?php

class Waindigo_LastPostAvatar_Listener_TemplatePostRender extends Waindigo_Listener_TemplatePostRender
{

    protected function _getTemplates()
    {
        return array(
            'node_forum_level_1',
            'node_forum_level_2',
            'node_category_level_2',
            'waindigo_node_level_1_socialgroups',
            'waindigo_node_level_2_socialgroups',
            'waindigo_library_level_1_library',
            'waindigo_library_level_2_library',
            'waindigo_social_forum_list_item_socialgroups'
        );
    } /* END _getTemplates */

    public static function templatePostRender($templateName, &$content, array &$containerData,
        XenForo_Template_Abstract $template)
    {
        $templatePostRender = new Waindigo_LastPostAvatar_Listener_TemplatePostRender($templateName, $content,
            $containerData, $template);
        list($content, $containerData) = $templatePostRender->run();
    } /* END templatePostRender */

    protected function _nodeForumLevel1()
    {
        return $this->_nodeForumLevel2();
    } /* END _nodeForumLevel1 */

    protected function _nodeForumLevel2()
    {
        $viewParams = $this->_fetchViewParams();
        $lastPostTitleMaxChars = XenForo_Application::get('options')->waindigo_lastPostAvatar_lastPostTitleMaxLength;
        if (isset($viewParams['forum'])) {
            $node = $viewParams['forum'];
            if (!$node['lastPost']['date']) {
                return;
            }
            $rendered = $this->_render('waindigo_node_forum_avatar_lastpostavatar');
            $title = XenForo_Helper_String::wholeWordTrim($node['lastPost']['title'], $lastPostTitleMaxChars);
        } else
            if (isset($viewParams['category'])) {
                $node = $viewParams['category'];
                if (!$node['lastPost']['date']) {
                    return;
                }
                $rendered = $this->_render('waindigo_node_category_avatar_lastpostavatar');
                $title = XenForo_Helper_String::wholeWordTrim($node['lastPost']['title'], $lastPostTitleMaxChars);
            } else
                if (isset($viewParams['library'])) {
                    $node = $viewParams['library'];
                    if (!$node['lastArticlePage']['date']) {
                        return;
                    }
                    $rendered = $this->_render('waindigo_node_library_avatar_lastpostavatar');
                    $title = XenForo_Helper_String::wholeWordTrim($node['lastArticlePage']['title'],
                        $lastPostTitleMaxChars);
                }
        if (!isset($node['privateInfo']) || !$node['privateInfo']) {
    		$pattern = '#(<div class="nodeLastPost(?: secondaryContent)?">)(.*)(<a[^>]*>)[^<]*(</a>)#Us';
            $replacement = '${1}' . $rendered . '${2}' . '${3}' . $title . '${4}';
            $this->_contents = preg_replace($pattern, $replacement, $this->_contents, 1);
        }
    } /* END _nodeForumLevel2 */

    protected function _nodeCategoryLevel2()
    {
        return $this->_nodeForumLevel2();
    } /* END _nodeCategoryLevel2 */

    protected function _waindigoNodeLevel1Socialgroups()
    {
        return $this->_nodeForumLevel2();
    } /* END _waindigoNodeLevel1Socialgroups */

    protected function _waindigoNodeLevel2Socialgroups()
    {
        return $this->_nodeForumLevel2();
    } /* END _waindigoNodeLevel2Socialgroups */

    protected function _waindigoLibraryLevel1Library()
    {
        return $this->_nodeForumLevel2();
    } /* END _waindigoLibraryLevel1Library */

    protected function _waindigoLibraryLevel2Library()
    {
        return $this->_nodeForumLevel2();
    } /* END _waindigoLibraryLevel2Library */

    protected function _waindigoSocialForumListItemSocialgroups()
    {
        return $this->_nodeForumLevel2();
    } /* END _waindigoSocialForumListItemSocialgroups */
}