<?php

/**
 *
 * @see XenForo_Model_Node
 */
class Waindigo_LastPostAvatar_Extend_XenForo_Model_Node extends XFCP_Waindigo_LastPostAvatar_Extend_XenForo_Model_Node
{

    /**
     *
     * @see XenForo_Model_Node::getNodeDataForListDisplay()
     */
    public function getNodeDataForListDisplay($parentNode, $displayDepth, array $nodePermissions = null)
    {
        $nodeData = parent::getNodeDataForListDisplay($parentNode, $displayDepth, $nodePermissions);
        if (!empty($nodeData)) {
            $groupedNodes = $nodeData['nodesGrouped'];

            $this->_addAvatarInfoForLastPostUsers($groupedNodes);

            if (XenForo_Application::$versionId < 1020000) {
                $nodeData['nodeParents'] = array();
            }

            return array(
			    'nodeParents' => $nodeData['nodeParents'],
                'nodesGrouped' => $groupedNodes,
                'parentNodeId' => $nodeData['parentNodeId'],
                'nodeHandlers' => $nodeData['nodeHandlers'],
                'nodePermissions' => $nodeData['nodePermissions']
            );
        } else {
            return array();
        }
    } /* END getNodeDataForListDisplay */

    /**
     *
     * @param array $nodes
     */
    protected function _addAvatarInfoForLastPostUsers(array &$nodes)
    {
        $users = array();
        foreach ($nodes as &$depthNodes)
            foreach ($depthNodes as &$node) {
                if (isset($node['lastPost']['user_id']) && !isset($node['lastPost']['avatar_date'])) {
                    $users[$node['lastPost']['user_id']] = array();
                } else
                    if (isset($node['lastArticlePage']['user_id']) && !isset($node['lastArticlePage']['avatar_date'])) {
                        $users[$node['lastArticlePage']['user_id']] = array();
                    }
            }
        if (isset($users[0])) {
            unset($users[0]);
        }

        if (!empty($users)) {
            $users = $this->_getAvatarInfoForUsers(array_keys($users));

            foreach ($nodes as &$depthNodes)
                foreach ($depthNodes as &$node) {
                    if (($node['node_type_id'] == "Category" || $node['node_type_id'] == "Forum" ||
                         $node['node_type_id'] == "SocialCategory") && isset($node['lastPost']['user_id']) &&
                         !empty($users[$node['lastPost']['user_id']])) {
                        $node['lastPost']['avatar_date'] = $users[$node['lastPost']['user_id']]['avatar_date'];
                        $node['lastPost']['gravatar'] = $users[$node['lastPost']['user_id']]['gravatar'];
                        $node['lastPost']['gender'] = $users[$node['lastPost']['user_id']]['gender'];
                    } else
                        if (($node['node_type_id'] == "Library") && isset($node['lastArticlePage']['user_id']) &&
                             !empty($users[$node['lastArticlePage']['user_id']])) {
                            $node['lastArticlePage']['avatar_date'] = $users[$node['lastArticlePage']['user_id']]['avatar_date'];
                            $node['lastArticlePage']['gravatar'] = $users[$node['lastArticlePage']['user_id']]['gravatar'];
                            $node['lastArticlePage']['gender'] = $users[$node['lastArticlePage']['user_id']]['gender'];
                        }
                }
        }
    } /* END _addAvatarInfoForLastPostUsers */

    /**
     *
     * @param array|int $userIds
     * @return array
     */
    protected function _getAvatarInfoForUsers($userIds)
    {
        if (!$userIds) {
            return array();
        }
        return $this->fetchAllKeyed(
            '
			SELECT user.user_id, user.avatar_date, user.gravatar, user.gender
			FROM xf_user AS user
			WHERE user.user_id IN (' . $this->_getDb()
                ->quote($userIds) . ')
		', 'user_id');
    } /* END _getAvatarInfoForUsers */
}