<?php

class XenResource_Listener_Proxy
{
	protected static $_addedUsernameChange = false;

	public static function loadModel($class, array &$extend)
	{
		if ($class == 'XenForo_Model_Moderator')
		{
			$extend[] = 'XenResource_Listener_Proxy_ModelModerator';
		}

		if (!self::$_addedUsernameChange
			&& $class == 'XenForo_Model_User'
			&& XenForo_Application::$versionId >= 1020031
		)
		{
			self::$_addedUsernameChange = true;
			XenForo_Model_User::$userContentChanges['xf_resource'] = array(array('user_id', 'username'));
		}
	}

	public static function loadDataWriter($class, array &$extend)
	{
		if (!self::$_addedUsernameChange
			&& $class == 'XenForo_DataWriter_User'
			&& XenForo_Application::$versionId < 1020031
		)
		{
			self::$_addedUsernameChange = true;
			XenForo_DataWriter_User::$usernameChangeUpdates['permanent']['resource_username'] =
				array('xf_resource', 'username', 'user_id');
		}
	}

	public static function dependencies(XenForo_Dependencies_Abstract $dependencies, array $data)
	{
		if ($dependencies instanceof XenForo_Dependencies_Admin)
		{
			XenForo_CacheRebuilder_Abstract::$builders['Resource'] = 'XenResource_CacheRebuilder_Resource';
			XenForo_CacheRebuilder_Abstract::$builders['ResourceCategory'] = 'XenResource_CacheRebuilder_Category';
		}
	}
}