<?php
class WP_TrimThumb_0_1 {
	protected $options;
	function __construct($options = array()){
		$this->options = $options = wp_parse_args($options, array(
			'wp_ajax_prefix' => 'trimthumb',
			'custom_entry_point' => false,
			'allow_custom_sizes' => false
		));
		if ($options['wp_ajax_prefix']){
			add_action('wp_ajax_' . $options['wp_ajax_prefix'] . '_get_image', array($this, 'get_image'));
			add_action('wp_ajax_nopriv_' . $options['wp_ajax_prefix'] . '_get_image', array($this, 'get_image'));
		}
	}
	
	function get_image_url($options = array()){
		$options = wp_parse_args($options, array(
			'action' => $this->options['wp_ajax_prefix'] . '_get_image'
		));
		$url = $this->options['custom_entry_point'] ? $this->options['custom_entry_point'] : admin_url('admin-ajax.php', 'relative');
		return add_query_arg($options, $url);
	}
	
	function get_image(){
		$options = wp_parse_args($_GET, array(
		));
		$attachment = get_posts(array('p' => $options['id'], 'post_type' => 'attachment'));
		if (!count($attachment)){
			$this->render_404();
		}
		$attachment = $attachment[0];
		if (false === ($cached_file = $this->get_cached_file($attachment, $options))){
			$cache_file = $this->create_cache_file($attachment, $options);
		}
		$this->render_file($attachment, $cache_file);
	}
	
	function render_404(){
		status_header( 404 );
		nocache_headers();
		exit;
	}
	
	function create_cache_file($attachment, $options){
		$size = $this->get_size($attachment, $options);
		$file = get_attached_file($attachment->ID);
		if (!$file)
			$this->render_404();
		if (!$size['width'] && !$size['height'])
			return $file;
		$editor = wp_get_image_editor($file);
		$editor->resize($size['width'], $size['height'], $size['crop']);
		$filename = $this->get_file_name($attachment, $size);
		$editor->save($filename);
		return $filename;
	}
	
	function get_file_name($attachment, $size){
		$file = get_attached_file($attachment->ID);
		$pathinfo = pathinfo($file);
		$suffix = "-" . $size['width'] . "x" . $size['height'];
		return $pathinfo['dirname'] . "/" . $pathinfo['filename'] . $suffix . "." . $pathinfo['extension'];
	}
	
	function get_size($attachment, $options){
		if (isset($options['size']) && $options['size']){
			return $this->get_named_size($options['size']);
		}
		if ($this->options['allow_custom_sizes'] && isset($options['width']) || isset($options['height']))
			return array(
			'width' => isset($options['width']) && (int)$options['width'] ? (int)$options['width'] : null,
			'height' => isset($options['height']) && (int)$options['height'] ? (int)$options['height'] : null,
			'crop' => isset($options['crop']) && (bool)$options['crop'] ? (bool)$options['crop'] : null
		);
		return $this->get_named_size('thumbnail');
	}
	
	function get_named_size($size){
		if (in_array($size, get_intermediate_image_sizes())){
			global $_wp_additional_image_sizes;
			if (isset($_wp_additional_image_sizes[$size]))
				return $_wp_additional_image_sizes[$size];
			return array(
				'width' => get_option( "{$size}_size_w" ),
				'height' => get_option( "{$size}_size_h" ),
				'crop' => get_option( "{$size}_crop" )
			);
		}
	}
	
	function get_cached_file($attachment, $options){
		return false;
	}
	function render_file($attachment, $file){
		$mime_type = get_post_mime_type($attachment->ID);
		$gmdate_mod = gmdate ("D, d M Y H:i:s", filemtime($file));
		if (! strstr ($gmdate_mod, "GMT")) {
			$gmdate_mod .= " GMT";
		}
		if (isset ($_SERVER["HTTP_IF_MODIFIED_SINCE"])) {
			$if_modified_since = preg_replace ("/;.*$/", "", $_SERVER["HTTP_IF_MODIFIED_SINCE"]);
			if ($if_modified_since == $gmdate_mod) {
				header ('HTTP/1.1 304 Not Modified');
				exit;
			}
		}

		clearstatcache ();
		$filesize = filesize ($file);

		// send headers then display image
		header ('Content-Type: ' . $mime_type);
		header ('Accept-Ranges: bytes');
		header ('Last-Modified: ' . $gmdate_mod);
		header ('Content-Length: ' . $filesize);
		header ('Cache-Control: max-age=9999, must-revalidate');
		header ('Expires: ' . $gmdate_mod);
		if (!@readfile ($file)) {
			$content = file_get_contents ($file);
			if ($content != FALSE) {
				echo $content;
			} else {
				$this->render_404();
			}
		}
		exit;
	}

}
global $wpthumb;
$wpthumb = new WP_TrimThumb_0_1();