<?php
if (!class_exists('Karevn_Updater_1_0')){
	class Karevn_Updater_1_0{
		var $api_url;
		var $slug;
		var $basename;
		public function __construct($api_url, $slug, $basename){
			$this->api_url = $api_url;
			$this->slug = $slug;
			$this->basename = $basename;
			add_filter('pre_set_site_transient_update_plugins', array($this, 'check_for_updates'));
			// Take over the Plugin info screen
			add_filter('plugins_api', array($this, 'my_plugin_api_call'), 10, 3);
		}
	
		// Take over the update check
		public function check_for_updates($checked_data) {
			if (empty($checked_data->checked))
				return $checked_data;
			$response = $this->post('basic_check', array(
			'slug' => $this->slug,
			'version' => $checked_data->checked[$this->basename]
			));
			if (!is_wp_error($response) && !empty($response) && $response['response']['code'] == 200){
				$response = unserialize($response['body']);
				if (is_object($response) && !empty($response) && 
					version_compare($checked_data->checked[$this->basename], $response->version) == -1) // Feed the update data into WP updater
					$checked_data->response[$this->basename] = $response;
			}
			return $checked_data;
		}

		public function my_plugin_api_call($def, $action, $args) {
			if ($action == 'query_plugins')
				return $def;
			if (!isset($args->slug) || $args->slug != $this->slug)
				return false;
			// Get the current version
			$plugin_info = get_site_transient('update_plugins');
			$args->version = $plugin_info->checked[$this->basename];
			$request = $this->post($action, $args);
			if (is_wp_error($request)) {
				$res = new WP_Error('plugins_api_failed', __('An Unexpected HTTP Error occurred during the API request.</p> <p><a href="?" onclick="document.location.reload(); return false;">Try again</a>'), $request->get_error_message());
			} else {
				$res = unserialize($request['body']);
				if ($res === false)
					$res = new WP_Error('plugins_api_failed', __('An unknown error occurred'), $request['body']);
			}
			return $res;
		}
	
		function post($action, $args){
			return wp_remote_post($this->api_url, $this->build_request($action, $args));
		}

		function build_request($action, $args) {
			global $wp_version;
			return array(
				'body' => array(
					'action' => $action, 
					'request' => serialize($args),
					'api-key' => md5(get_bloginfo('url')),
					'url' => get_bloginfo('url')
				),
				'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo('url')
			);	
		}
	}
}

$ubergrid_updater = new Karevn_Updater_1_0('http://api.karevn.com', 'uber-grid', plugin_basename(UBERGRID_MAIN));
