<?php if ($this->font_families()): ?>
	<link rel="stylesheet" type="text/css" href="http://fonts.googleapis.com/css?family=<?php echo urlencode(implode('|', $this->font_families())) ?>"></link>
<?php endif ?>

<?php if (!get_option('uber_grid_use_external_stylesheet') || $options['css']): ?>
	<style type="text/css"><?php $this->render_css() ?></style>
<?php endif ?>
<div class="uber-grid-wrapper" id="uber-grid-wrapper-<?php echo $this->id ?>">
	<?php if (count($this->get_tags())): ?>
		<ul class="uber-grid-filters">
			<li><a href="#"><?php _e($this->filters_all, 'uber-grid')?></a></li>
			<?php foreach($this->get_tags() as $tag): ?>
			<li><a href="#<?php echo esc_attr($tag) ?>"><?php echo esc_html($tag)?></a></li>
			<?php endforeach ?>
		</ul>
	<?php endif ?>
	<ul class="<?php echo implode(' ', $this->grid_classes()) ?>" id="uber-grid-<?php echo $this->id ?>" data-cell-width="<?php echo $this->cell_width ?>" data-cell-border="<?php echo $this->cell_border_width ?>" data-cell-gap="<?php echo $this->cell_gap ?>">
		<?php $index = 0 ?>
		<?php foreach($this->cells as $cell): ?>
			<li id="uber-grid-<?php echo $this->id ?>-cell-<?php echo $index ?>" class="<?php echo str_replace('-', ' ', $cell->layout) ?> <?php echo $cell->hover_enable ? "uber-grid-hover" : '' ?> <?php echo $cell->label_enable ? 'uber-grid-has-label' : '' ?>" data-tags="<?php echo esc_attr($cell->tags) ?>"><?php require("cell.php") ?></li>
		<?php $index ++ ?>
		<?php endforeach ?>
	</ul>
</div>
<?php if (current_user_can('manage_options') && $options['show_edit']): ?>
	<div class="uber-grid-edit-wrapper"><a href="<?php echo admin_url("post.php?post={$this->id}&action=edit") ?>" class="edit-grid"><?php _e('Edit grid', 'uber-grid')?></a></div>
<?php endif ?>