<?php require('grid-style-grid.php') ?>
<?php $i = 0 ?>
<?php foreach($this->cells as $cell): ?>
	<?php if ($cell->background_color): ?>
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?>{
			background-color: <?php echo uber_grid_color($cell->background_color) ?>;
		}
	<?php endif ?>
	
	<?php if ($cell->title_background_color || $cell->title_background_image): ?>
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title-wrapper{
			background-color: <?php echo uber_grid_color($cell->title_background_color, preg_match('/\-io$/', $cell->layout)) ?>;
			background-color: <?php echo uber_grid_color($cell->hover_background_color, preg_match('/\-io$/', $cell->layout) ? '0.8' : 1) ?>;
			background: -moz-linear-gradient(top left,  rgba(0,0,0,0.1) 0%, rgba(0,0,0,0) 100%), <?php echo uber_grid_color($cell->title_background_color, preg_match('/\-io$/', $cell->layout) ? '0.8' : 1) ?>; /* FF3.6+ */
			background: -webkit-gradient(linear, left top, right bottom, color-stop(0%,rgba(0,0,0,0.1)), color-stop(100%,rgba(0,0,0,0))), <?php echo uber_grid_color($cell->title_background_color, preg_match('/\-io$/', $cell->layout) ? '0.8' : 1) ?>; /* Chrome,Safari4+ */
			background: -o-linear-gradient(to top left,  rgba(0,0,0,0.1) 0%, rgba(0,0,0,0) 100%), <?php echo uber_grid_color($cell->title_background_color, preg_match('/\-io$/', $cell->layout) ? '0.8' : 1); ?>; /* Opera 11.10+ */
			background: -ms-linear-gradient(top,  rgba(0,0,0,0.1) 0%,rgba(0,0,0,0) 100%), <?php echo uber_grid_color($cell->title_background_color, preg_match('/\-io$/', $cell->layout) ? '0.8' : 1); ?>; /* IE10+ */
			background: linear-gradient(to top left,  rgba(0,0,0,0.1) 0%,rgba(0,0,0,0) 100%), <?php echo uber_grid_color($cell->title_background_color, preg_match('/\-io$/', $cell->layout) ? '0.8' : 1);?>; /* W3C */
			<?php if ($cell->title_background_image): ?>
				background-image: url(<?php echo $cell->getTitleBackgroundImageSrc() ?>)  !important;
			<?php endif ?>
			
		}
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title-wrapper:after{
			<?php if ($cell->imageLocation() == 'ir'): ?>
				border-left-color: <?php echo uber_grid_color($cell->title_background_color) ?>;
			<?php elseif ($cell->imageLocation() == 'il'): ?>
				border-right-color: <?php echo uber_grid_color($cell->title_background_color) ?>;
			<?php elseif ($cell->imageLocation() == 'ib'): ?>
				border-top-color: <?php echo uber_grid_color($cell->title_background_color) ?>;
			<?php elseif ($cell->imageLocation() == 'it'): ?>
				border-bottom-color: <?php echo uber_grid_color($cell->title_background_color) ?>;
			<?php endif ?>
		}
	<?php endif ?>
	<?php switch($cell->title_position): ?><?php case 'center': ?>
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title{
			text-align: center !important;
			line-height: 1.4 !important;
			box-sizing: border-box !important;
			-moz-box-sizing: border-box !important;
			padding-top: <?php echo $this->cell_height / 2 ?>px;
		}
		@media screen and (max-width: 768px){
			li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title{
				padding-top: <?php echo $this->responsive_768_cell_height / 2 ?>px;
			}
		}
		@media screen and (max-width: 440px){
				li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title{
				padding-top: <?php echo $this->responsive_440_cell_height / 2 ?>px;
			}
		}
		
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title strong{
			display: block !important;
			margin-top: -<?php echo (($this->title_font_size ? $this->title_font_size : 13) * 1.2 + ($this->tagline_font_size ? $this->tagline_font_size : 13) * 1.2) / 2 ?>px;
		}
	<?php break ?><?php case 'top-center'?><?php case 'top-left' ?><?php case 'top-right'?>
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title{
			padding: 8%;
			text-align: <?php echo str_replace('top-', '', $cell->title_position)?>;
		}
	<?php break ?>
	<?php break ?><?php case 'bottom-center'?><?php case 'bottom-left' ?><?php case 'bottom-right'?>
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title{
			bottom: 0;
			right: 0;
			height: auto;
			top: auto;
			position: absolute;
			padding: 8%;
			text-align: <?php echo str_replace('bottom-', '', $cell->title_position)?>;
		}
	<?php break ?>
	<?php break ?><?php case 'top-left-bottom-left'?><?php case 'top-left-bottom-right'?>
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title{
			top: 0;
			left: 0;
			width: 100%;
			height: 100%;
			text-align: left;
		}
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title strong{
			position: absolute;
			top: 8%;
			left: <?php echo $cell->get_image_columns() == 1 ? '8' : '4' ?>%;
			right: <?php echo $cell->get_image_columns() == 1 ? '8' : '4' ?>%
		}
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title small{
			position: absolute;
			bottom: 8%;
			<?php echo str_replace('top-left-bottom-', '', $cell->title_position) ?>: <?php echo $cell->get_image_columns() == 1 ? '8' : '4' ?>%;
		}
	<?php break ?><?php case 'top-right-bottom-left'?><?php case 'top-right-bottom-right'?>
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title{
			top: 0;
			left: 0;
			width: 100%;
			height: 100%;
			text-align: right;
		}
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title strong{
			position: absolute;
			left: <?php echo $cell->get_image_columns() == 1 ? '8' : '4' ?>%;
			right: <?php echo $cell->get_image_columns() == 1 ? '8' : '4' ?>%
			text-aligh: right;
		}
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title small{
			position: absolute;
			bottom: 8%;
			<?php echo str_replace('top-right-bottom-', '', $cell->title_position) ?>: 8%;
			max-width: 92%
		}
	
	<?php endswitch ?>
	<?php if ($cell->title_color): ?>
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title strong{
			color: <?php echo uber_grid_color($cell->title_color) ?>;
		}
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?>.io .uber-grid-cell-title strong{
			color: <?php echo $cell->title_color ?>;
		}
	<?php endif ?>
	
	<?php if ($cell->tagline_color): ?>
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-title small{
			color: <?php echo uber_grid_color($cell->tagline_color) ?>;
		}
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?>.io .uber-grid-cell-title small{
			color: <?php echo $cell->tagline_color ?>;
		}
	<?php endif ?>
	
	<?php if ($cell->hover_enable): ?>
			<?php if ($cell->hover_text_color): ?>
				li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-hover,
				li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-hover a,
				li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-hover-title{
					color: <?php echo uber_grid_color($cell->hover_text_color) ?>;
				}
			<?php endif ?>
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-hover{
			<?php if ($cell->hover_background_color): ?>
				background-color: <?php echo uber_grid_color($cell->hover_background_color) ?>;
				background-color: <?php echo uber_grid_color($cell->hover_background_color, 0.9) ?>;
			<?php endif ?>
			<?php if ($cell->hover_background_image): ?>
				background-image: url(<?php echo $cell->getHoverBackgroundImageSrc() ?>) !important;
			<?php endif ?>
			padding: <?php echo $cell->get_columns() == 1 ? '8' : '4'?>%;
		}
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-hover strong.uber-grid-hover-title{
			margin-bottom: <?php echo (($this->title_font_size ? $this->title_font_size : 13) * 1.2 + ($this->tagline_font_size ? $this->tagline_font_size : 13) * 1.2) / 4 ?>px;
		}
	<?php endif ?>
	<?php if ($cell->label_enable): ?>
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-label{
			background-color: <?php echo uber_grid_color($cell->label_background_color) ?>;
		}
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-label strong,
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-label .uber-grid-price-tag{
			color: <?php echo uber_grid_color($cell->label_title_color) ?>;
		}
		li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-label small{
			color: <?php echo uber_grid_color($cell->label_tagline_color) ?>;
		}
		<?php if ($cell->label_price_background_color || $cell->label_price_color): ?>
			li#uber-grid-<?php echo $this->id ?>-cell-<?php echo $i ?> .uber-grid-cell-label .uber-grid-price-tag{
				<?php if ($cell->label_price_background_color): ?>
					background: <?php echo uber_grid_color($cell->label_price_background_color) ?>;
				<?php endif ?>
				<?php if ($cell->label_price_color): ?>
					color: <?php echo uber_grid_color($cell->label_price_color) ?>;
				<?php endif ?>
			}
		<?php endif ?>
	<?php endif ?>
	<?php $i++ ?>
<?php endforeach ?>