<?php
class UberGrid_Shortcodes{
	function __construct(){
		add_shortcode('uber_grid', array($this, 'uber_grid'));
		add_shortcode('ubergrid', array($this, 'uber_grid'));
		add_action('wp_enqueue_scripts', array($this, '_wp_enqueue_scripts'), 0);
		add_action('wp', array($this, '_wp'));
		if (get_option('uber_grid_shortcode_hack')){
			add_filter('the_content', array($this, '_shortcode_hack'), 1000);
		}
	}
	
	function uber_grid($attributes = array(), $content = array()){
		if (!$id = intval($attributes['id']))
			return;
		if (get_option('uber_grid_shortcode_hack')){
			return "<!--ubergrid-$id-->";
		}
		return ubergrid($attributes['id']);	
	}
	
	function _shortcode_hack($content){
		return preg_replace_callback('/<\!\-\-ubergrid-(\d+)\-\->/', array($this, '_replace_callback'), $content);
	}
	function _replace_callback($matches){
		return ubergrid($matches[1]);
	}
	function _wp(){
		if (get_option('uber_grid_force_new_jquery')){
			wp_deregister_script('jquery');
			wp_register_script('jquery', UBERGRID_URL . "assets/js/jquery-1.10.2.js");
		}
	}
	
	function _wp_enqueue_scripts(){
		wp_enqueue_style('jquery.magnific-popup-ubergrid', UBERGRID_URL . "assets/css/magnific-popup.css", array(), UBERGRID_VERSION);
		wp_enqueue_style('uber-grid', UBERGRID_URL . "assets/css/uber-grid.css", array('jquery.magnific-popup-ubergrid'), UBERGRID_VERSION);
		if (get_option('uber_grid_use_external_stylesheet'))
			wp_enqueue_style('uber-grid-dynamic', UBERGRID_URL . "frontend-style.css.php", array('uber-grid'), UberGrid_Grid::css_timestamp());
		wp_enqueue_script('packery', UBERGRID_URL . "assets/js/packery.pkgd.min.js", array('jquery'), UBERGRID_VERSION);
		wp_enqueue_script('jquery.magnific-popup', UBERGRID_URL . "assets/js/jquery.magnific-popup.js", UBERGRID_VERSION);
		wp_enqueue_script('uber-grid', UBERGRID_URL . "assets/js/uber-grid.js", array('jquery', 'packery'), UBERGRID_VERSION);
	}
	
}

$ubergrid_shortcodes = new UberGrid_Shortcodes;

function ubergrid($id){
	global $ubergrid_shortcodes;
	if (false === ($text = get_transient("uber_grid_$id")) || is_user_logged_in()){
		$grid = new UberGrid_Grid();
		$grid->load($id);
		ob_start();
		$css = !get_option('uber_grid_use_external_stylesheet');
		$grid->render(array('css' => $css, 'style_tag' => $css, 'generate_thumbnails' => true));
		$text = ob_get_clean();
		if (get_option('uber_grid_enable_caching') && !is_user_logged_in())
			set_transient("uber_grid_$id", $text, 600);
	}
	// Strip whitespace between tags to prevent adding <p></p>.
	return preg_replace('/>\s+</', '><', $text);
}