<?php
	
class UberGrid_Grid{
	var $id;
	
	var $mode;
	
	var $cells;
	var $template;
	
	var $pagination_enabled;
	var $pagination_per_page = 12;

	var $cell_width = 160;
	var $cell_height = 160;
	var $cell_gap = 0;
	var $cell_border_width = 0;
	var $cell_border_color = "FFFFFF";
	var $cell_border_opacity = 1.0;
	var $cell_border_radius = 0;
	var $cell_shadow_radius = 0;
	
	var $responsive_440_cell_width = 120;
	var $responsive_440_cell_height = 120;
	var $responsive_440_cell_gap = 0;
	var $responsive_440_cell_border_width = 0;
	var $responsive_440_cell_border_radius = 0;
	var $responsive_440_title_font_size = 14;
	var $responsive_440_tagline_font_size = 11;
	var $responsive_440_hover_title_font_size = 14;
	var $responsive_440_hover_text_font_size = 11;
	var $responsive_440_label_title_font_size = 14;
	var $responsive_440_label_tagline_font_size = 11;
	var $responsive_440_label_price_font_size = 14;
	
	var $responsive_768_cell_width = 160;
	var $responsive_768_cell_height = 160;
	var $responsive_768_cell_gap = 0;
	var $responsive_768_cell_border_width = 0;
	var $responsive_768_cell_border_radius = 0;
	var $responsive_768_title_font_size = 18;
	var $responsive_768_tagline_font_size = 14;
	var $responsive_768_hover_title_font_size = 18;
	var $responsive_768_hover_text_font_size = 14;
	var $responsive_768_label_title_font_size = 18;
	var $responsive_768_label_tagline_font_size = 14;
	var $responsive_768_label_price_font_size = 18;
	
	
	
	var $title_font = "Marvel";
	var $title_font_style = "700";
	var $title_font_size = "24";
	
	var $tagline_font = "Marvel";
	var $tagline_font_style = "regular";
	var $tagline_font_size = "12";
	
	var $hover_text_font = "Marvel";
	var $hover_text_font_style = "regular";
	var $hover_text_font_size = "12";
	
	var $hover_title_font = "Marvel";
	var $hover_title_font_style = "700";
	var $hover_title_font_size = "18";
	
	var $lightbox_text_font = "Marvel";
	var $lightbox_text_font_style = "regular";
	var $lightbox_text_font_size = "13";
	
	var $lightbox_title_font = "Marvel";
	var $lightbox_title_font_style = "700";
	var $lightbox_title_font_size = "18";
	
	var $label_title_font = "Marvel";
	var $label_title_font_style = "regular";
	var $label_title_font_size = "16";
	
	var $label_tagline_font = "Marvel";
	var $label_tagline_font_style = "300";
	var $label_tagline_font_size = "12";

	var $label_price_font = "Marvel";
	var $label_price_font_style = "700";
	var $label_price_font_size = "24";
	
	var $filters_font = 'Marvel';
	var $filters_font_style = "700";
	var $filters_font_size = '18';
	var $filters_color = '#FFFFFF';
	var $filters_align = 'center';
	var $filters_background_color = '#ff6760';
	var $filters_accent_color = '#FFFFFF';
	var $filters_accent_background_color = "#616161";
	var $filters_all = 'All';
	
	var $bw;
	var $hover_effect;
	
	var $auto_enable = false;
	var $auto_post_type = 'post';
	var $auto_orderby = 'date';
	var $auto_order = 'DESC';
	var $auto_limit = '24';
	
	var $auto_taxonomies = array();
	var $auto_tags = array();
	
	var $auto_meta_keys = array();
	var $auto_meta_operators = array();
	var $auto_meta_values = array();
	var $auto_meta_types = array();
	
	
	function __construct($id = null, $options = array()){
		if (is_array($id) || $id){
			$this->load($id, $options);
		}
		if (!$this->template)
			$this->template = new UberGrid_CellTemplate;
	}
	
	
	function load($cells, $options = null){
		if (!is_array($cells)){
			$posts = get_posts("post_type=uber-grid&p=$cells");
			if (!count($posts))
				return;
			$post = $posts[0];
			if ($post->post_status != 'publish')
				return;
			$this->id = $cells;
			$cells = get_post_meta($cells, '_cells', true);
			$options['template'] = get_post_meta($this->id, '_template', true);
			$options['layout'] = get_post_meta($this->id, '_layout', true);
			$options['fonts'] = get_post_meta($this->id, '_fonts', true);
			$options['effects'] = get_post_meta($this->id, '_effects', true);
			$this->mode = ($mode = get_post_meta($this->id, '_current-mode', true)) ? $mode : 'manual';
			$options['auto'] = get_post_meta($this->id, '_auto', true);
			$options['pagination'] = get_post_meta($this->id, '_pagination', true);
			$options['responsive_440'] = get_post_meta($this->id, '_responsive_440', true);
			$options['responsive_768'] = get_post_meta($this->id, '_responsive_768', true);
		}
		$this->cells = array();
		if (is_array($cells)){
			foreach($cells as $cell){
				$this->cells []= new UberGrid_Cell($cell);
			}
		}
		if ($options){
			if (isset($options['layout']) && $options['layout']){
				$this->assign_layout_options($options['layout']);
			}
			if (isset($options['fonts']) && $options['fonts']){
				$this->assign_font_options($options['fonts']);
			}
			if (isset($options['effects']) && $options['effects']){
				$this->assign_effects_options($options['effects']);
			}
			if (isset($options['auto']) && $options['auto']){
				$this->assign_auto_options($options['auto']);
			}
			if (isset($options['template'])){
				$this->template = new Ubergrid_CellTemplate($options['template']);
			}
			if (isset($options['pagination'])){
				$this->assign_pagination_options($options['pagination']);
			}
			if (isset($options['responsive_440'])){
				$this->assign_responsive_440_options($options['responsive_440']);
			}
			if (isset($options['responsive_768'])){
				$this->assign_responsive_768_options($options['responsive_768']);
			}
			
		}
	}
	
	function assign_pagination_options($options){
		foreach(array('enabled', 'per_page') as $property){
			if (isset($options[$property])){
				$name = 'pagination_' . $property;
				$this->$name = $options[$property];
			}
		}
	}
	
	function assign_font_options($layout){
		foreach(array('title_font', 'title_font_style', 'title_font_size', 'tagline_font', 'tagline_font_style', 'tagline_font_size', 'hover_text_font', 'hover_text_font_style', 'hover_text_font_size', 'hover_title_font', 'hover_title_font_style', 'hover_title_font_size', 'lightbox_text_font', 'lightbox_text_font_style', 'lightbox_text_font_size', 'lightbox_title_font', 'lightbox_title_font_style', 'lightbox_title_font_size', 'label_title_font', 'label_title_font_style', 'label_title_font_size', 'label_tagline_font', 'label_tagline_font_style', 'label_tagline_font_size', 'label_price_font', 'label_price_font_style', 'label_price_font_size', 'filters_font', 'filters_font_size', 'filters_font_style', 'filters_color', 'filters_align', 'filters_accent_color', 'filters_accent_background_color', 'filters_all', 'filters_background_color') as $property){
			if (isset($layout[$property]))
				$this->$property = $layout[$property];
		}
	}
	
	function assign_responsive_440_options($responsive){
		foreach(array('cell_width', 'cell_height', 'cell_gap', 'cell_border_width', 'title_font_size', 'tagline_font_size', 'hover_title_font_size', 'hover_text_font_size', 'label_title_font_size', 'label_tagline_font_size', 'label_price_font_size', 'cell_border_radius') as $property){
	 			if (isset($responsive[$property])){
					$longproperty = "responsive_440_$property";
	 				$this->$longproperty = $responsive[$property];
	 			}
	 				
	 		}
	}
	function assign_responsive_768_options($responsive){
		foreach(array('cell_width', 'cell_height', 'cell_gap', 'cell_border_width', 'title_font_size', 'tagline_font_size', 'hover_title_font_size', 'hover_text_font_size', 'label_title_font_size', 'label_tagline_font_size', 'label_price_font_size', 'cell_border_radius') as $property){
	 			if (isset($responsive[$property])){
					$longproperty = "responsive_768_$property";
	 				$this->$longproperty = $responsive[$property];
	 			}
	 				
	 		}
	}
	
	function assign_auto_options($options){
		foreach (array('post_type', 'taxonomies', 'tags', 'meta_keys', 'meta_values', 'meta_types', 'meta_operators', 'order', 'orderby', 'limit', 'enable') as $property){
			$property_name = "auto_$property";
			if (isset($options[$property]))
				$this->$property_name = $options[$property];
		}
	}
	
	function assign_layout_options($layout){
		foreach(array('cell_width', 'cell_height', 'cell_gap', 'cell_border_width', 'cell_border_color', 'cell_border_opacity', 'cell_shadow_radius', 'cell_border_radius') as $property){
			if (isset($layout[$property]) && $layout[$property])
				$this->$property = $layout[$property];
		}
	}
	
	function assign_effects_options($effects){
		foreach(array('bw', 'hover_effect') as $property){
			if (isset($effects[$property]) && $effects[$property])
				$this->$property = $effects[$property];
		}
	}
	
	function get_images(){
		$images = array();
		if ($this->cells)
		foreach($this->cells as $cell){
			$images []= $cell->image;
			$images []= $cell->background_image;
			$images []= $cell->title_background_image;
			$images []= $cell->lightbox_image;
		}
		return array_unique(array_filter($images));
	}
	
	function get_2x_width(){
		return $this->cell_width * 2 + $this->cell_border_width * 2 + $this->cell_gap * 2;
	}
	
	function get_2x_height(){
		return $this->cell_height * 2 + $this->cell_border_width * 2 + $this->cell_gap * 2;
	}
	
	function get_required_image_sizes(){
		$sizes = array(
			array($this->cell_width, $this->cell_height),
			array($this->get_2x_width(), $this->cell_height),
			array($this->cell_width, $this->get_2x_height()),
			array($this->get_2x_width(), $this->get_2x_height())
		);
		$result = array();
		foreach($sizes as $size){
			$result["uber-grid-{$size[0]}x{$size[1]}"] = $size;
		}
		return $result;
	}
	function create_image_sizes(){
		foreach($this->get_required_image_sizes() as $size => $params){
			add_image_size($size, $params[0], $params[1], true);
		}
	}
	
	function regenerate_thumbnails(){
		$this->create_image_sizes();
		foreach ($this->get_images() as $image){
			if ($this->image_requires_regeneration($image))
			wp_update_attachment_metadata($image, wp_generate_attachment_metadata($image, get_attached_file($image)));
		}
	}
	
	function image_requires_regeneration($image){
		$metadata = wp_get_attachment_metadata($image);
		foreach($this->get_required_image_sizes() as $size => $data){
			if (!isset($metadata['sizes'][$size]) || $metadata['sizes'][$size]['width'] != (int)$data[0] || $metadata['sizes'][$size]['height'] != $data[1]){
				return true;
			}
		}
		return false;
	}
	
	function render($options = array()){
		$options = wp_parse_args($options, array('generate_thumbnails' => false));
		$this->create_image_sizes();
		if ($this->auto_enable)
			$this->cells = array_merge($this->cells, $this->build_auto_cells($options));
		$options = wp_parse_args($options, array('show_edit' => true, 'css' => true, 'html' => true));
		if (isset($options['css']) && $options['css'])
			$this->render_css(isset($options['style_tag']) && $options['style_tag']);
		if (isset($options['html']) && $options['html'])
			$this->render_html($options);
	}
	
	function render_css($style_tag = false){
		if ($style_tag)
			echo "<style type='text/css'>";
		require('templates/grid-style.css.php');
		if ($style_tag)
			echo "</style>";
	}
	function build_auto_cells($options = array()){
		$options = wp_parse_args($options, array('generate_thumbnails' => false));
		$query = array(
			'post_type' => $this->auto_post_type,
			'posts_per_page' => $this->auto_limit ? (int)$this->auto_limit : '-1',
			'orderby' => $this->auto_orderby,
			'order' => $this->auto_order,
			'tax_query' => $this->build_auto_tax_query(),
			'meta_query' => $this->build_meta_query()
		);
		$auto_cells = array();
		foreach(get_posts($query) as $post){
			$auto_cells []= $this->template->build_cell($post, array('width' => $this->cell_width, 'height' => $this->cell_height, 'generate_thumbnail' => $options['generate_thumbnails']));
		}
		return $auto_cells;
	}
	

	function build_meta_query(){
		$meta_query = array();
		for ($i = 0; $i < count($this->auto_meta_keys); $i++ ){
			$meta_query []= array(
				'key' => $this->auto_meta_keys[$i],
				'compare' => $this->auto_meta_operators[$i],
				'value' => $this->auto_meta_values[$i],
				'type' => $this->auto_meta_types[$i]
			);
		}
		return $meta_query;
	}
	function build_auto_tax_query(){
		$tax_query = array();
		for ($i = 0; $i < count($this->auto_taxonomies); $i++){
			$tax_query []= array(
				'taxonomy' => $this->auto_taxonomies[$i],
				'field' => 'slug', 
				'terms' => array_map('trim', explode(',', $this->auto_tags[$i]))
			);
		}
		return $tax_query;
	}
	
	function render_html($options){
		if (count($this->cells))
			require("templates/grid.php");
		else
			require("templates/grid-blank-slate.php");
	}
	
	static function css_timestamp(){
		$posts = get_posts('post_type=uber-grid&order=desc&posts_per_page=1');
		if ($posts){
			return $posts[0]->post_modified;
		}
		else return '';
	}
	
	function font_families(){
		return array_unique(array_filter(array($this->title_font, $this->tagline_font, $this->hover_text_font, $this->hover_title_font, 
			$this->lightbox_text_font, $this->lightbox_title_font, $this->label_title_font, $this->label_tagline_font, $this->label_price_font)));
	}
	
	function parse_font_weight($style){
		if (in_array($style, array('', 'regular', 'italic')))
			return '400';
		if (preg_match('/^(\d{3,4})/', $style, $matches))
			return $matches[0];
		return '400';
	}
	
	function parse_font_style($style){
		if (in_array($style, array('', 'regular', 'italic')))
			return $style;
		if (preg_match('/^(\d{3,4}.+)/', $style, $matches))
			return preg_replace('/^(\d{3,4})/', '', $style);
		return 'normal';
	}
	
	function grid_classes(){
		$classes = array('uber-grid');
		if ($this->bw)
			$classes []= 'uber-grid-bw';
		if ($this->hover_effect)
			$classes []= 'uber-grid-effect-' . $this->hover_effect;
		return $classes;
	}
	
	function get_tags(){
		$tags = array();
		foreach($this->cells as $cell){
			if (!$cell->tags)
				continue;
			foreach(array_map('trim', explode(', ', $cell->tags)) as $tag)
				$tags []= $tag;
		}
		return array_unique($tags);
	}
	
	function get_columns_width($columns){
		return $columns * ($this->cell_width + $this->cell_border_width * 2 + $this->cell_gap * 2);
	}
	
	function label_height(){
		return  (int)$this->label_title_font_size * 1.2 + (int)$this->label_tagline_font_size * 1.2 + 24;
	}
	
	function responsive_440_get_columns_width($columns){
		return $columns * ($this->responsive_440_cell_width + $this->responsive_440_cell_border_width * 2 + $this->responsive_440_cell_gap * 2);
	}
	
	function responsive_768_get_columns_width($columns){
		return $columns * ($this->responsive_768_cell_width + $this->responsive_768_cell_border_width * 2 + $this->responsive_768_cell_gap * 2);
	}
	
	function responsive_768_label_height(){
		return  (int)$this->responsive_768_label_title_font_size * 1.2 + (int)$this->responsive_768_label_tagline_font_size * 1.2 + 24;
	}
	function responsive_440_label_height(){
		return  (int)$this->responsive_440_label_title_font_size * 1.2 + (int)$this->responsive_440_label_tagline_font_size * 1.2 + 24;
	}
}
