<div class="wrap">
	<div class="icon32" id="icon-options-general"><br></div>
	<h2><?php _e('UberGrid Settings', 'uber-grid')?></h2>
	<form method="post" action="options.php" id="uber-grid-settings">
		<?php settings_fields( 'uber-grid-options' ) ?>
		<ul>
			<li class="clear"><h3><?php _e('Performance', 'uber-grid')?></li>
			<li class="clear">
				<label class="uber-grid-options-label"><?php _e('Disable inline styles', 'uber-grid')?></label>
				<p class="inputs">
					<label class="checkbox-label"><input type="checkbox" name="uber_grid_use_external_stylesheet" value="1" <?php echo checked(get_option('uber_grid_use_external_stylesheet')) ?>></label><em><?php _e('Loads all the styles from an separate file instead of inline style tag. Increases performance, but can lead to conflicts with cacning plugins and minifiers', 'uber-grid')?></em>
				</p>
			</li>
			<li class="clear">
				<label class="uber-grid-options-label"><?php _e('Enable caching', 'uber-grid')?></label>
				<p class="inputs">
					<label class="checkbox-label"><input type="checkbox" name="uber_grid_enable_caching" value="1" <?php echo checked(get_option('uber_grid_enable_caching')) ?>></label><em><?php _e('Increases rendering performance, can lead to random issues', 'uber-grid')?></em>
				</p>
			</li>
		
			<li class="clear"><h3><?php _e('Compatibility', 'uber-grid')?></li>
			<li class="clear">
				<label class="uber-grid-options-label"><?php _e('Use shortcode hack', 'uber-grid')?></label>
				<p class="inputs">
					<label class="checkbox-label"><input type="checkbox" name="uber_grid_shortcode_hack" value="1" <?php echo checked(get_option('uber_grid_shortcode_hack')) ?>></label><em><?php _e('Try this if UberGrid looks strange on your site', 'uber-grid')?></em>
				</p>
			</li>
			<li class="clear">
				<label class="uber-grid-options-label"><?php _e('Force new jQuery version', 'uber-grid')?></label>
				<p class="inputs">
					<label class="checkbox-label"><input type="checkbox" name="uber_grid_force_new_jquery" value="1" <?php echo checked(get_option('uber_grid_force_new_jquery')) ?>></label><em><?php _e('Try this if UberGrid does not work at your site', 'uber-grid')?></em>
				</p>
			</li>
			<li class="clear"><h3><?php _e('Self-diagnostics', 'uber-grid')?></li>
			<li class="diagnostics">
				<?php $uploads = wp_upload_dir() ?>
				Images directory writeable: <strong><?php echo $this->upload_permissions_ok() ? __('Yes', 'uber-grid') : sprintf(__('No. Please make sure that %s directory is writeable by Apache', 'uber-grid'), $uploads['basedir']) ?></strong><br>
				GD library installed: <strong><?php echo $this->gd_ok() ? __('Yes', 'uber-grid') : __('No', 'uber-grid') ?></strong><br>
				Stylesheet is publicly accessible: <strong><?php echo $this->stylesheet_accessible() ? __('Yes', 'uber-grid') : sprintf(__('No. Please make sure that the file %s is publicly accessible. You can check that opening the url with your browser', 'uber-grid'), "<a href='" . UBERGRID_URL . "frontend-style.css.php'>" . UBERGRID_URL . 'frontend-style.css.php' . "</a>" )?></strong><br>
			</li>
		</ul>
		<?php submit_button(); ?>
	</form>
</div>