<?php
class UberGrid_Diagnostics{
	function __construct(){
		add_action('admin_notices', array($this, '_admin_notices'));
	}
	
	function _admin_notices(){
		$this->check_wp_version();
		$screen = get_current_screen();
		if ($screen->parent_file != 'edit.php?post_type=uber-grid')
			return;
		$this->check_upload_permissions();
		$this->check_gd();
		$this->check_the_content_hooks();
		$this->check_max_input_vars();
		//$this->check_admin_ajax();
	}
	
	function check_admin_ajax(){
		if (($ajax = get_transient('uber_grid_admin_ajax_checked')) === false || true){
			$url = add_query_arg('action', 'uber_grid_ping', admin_url('admin-ajax.php'));
			$response = wp_remote_get($url);
			if (is_wp_error($response) || $response['body'] != 'working')
				$ajax = __('admin-ajax.php file is not available, making "Load more" feature unavailable. Most probably, you have installed a security plugin that disabled it. You can read more about this file at <a href="http://codex.wordpress.org/AJAX_in_Plugins">at WordPress Codex page</a>', 'uber-grid');
			else $ajax = true;
			set_transient('uber_grid_admin_ajax_checked', $ajax, 600);
		}
		if ($ajax !== true){
			$this->show_problem($ajax);
		}
	}
	
	function check_max_input_vars(){
		if (version_compare(phpversion(), '5.3.9', '>=') && ini_get('max_input_vars') <= 3000)
			$this->show_problem(__('If you\'ll experience problems with saving large grids or layout options, please increase <strong>max_input_vars</strong> PHP setting value to 3000 or more. You can learn more at <a href="http://codecanyon.net/item/ubergrid-responsive-grid-builder-for-wordpress/4851992/support">UberGrid\'s support page</a>.'));
	}
	
	function check_upload_permissions(){
		$dir = wp_upload_dir();
		if (!is_writable($dir['basedir']))
			$this->show_problem(sprintf(__('Upload folder is not writeable. Please allow a write access to %s'), $dir['basedir']));
	}
	
	function check_wp_version(){
		global $wp_version;
		if (version_compare($wp_version, UBERGRID_REQUIRED_WP, '<')){
			$this->show_problem(__('UberGrid requires WordPress 3.5 or newer. Please update your installation.', 'uber-grid'));
		}
	}
	
	function check_gd() {
		if (!(extension_loaded('gd') && function_exists('gd_info'))){
			$this->show_problem(sprintf(__('GD library does not seem to be installed. Please contact your web hosting administrator to install GD library.', 'uber-grid')));
		}
	}
	
	function check_the_content_hooks(){
		global $wp_filter;
		if (!class_exists('ReflectionFunction'))
			return;
		$suspects = array();
		if (isset($wp_filter['the_content']) && $wp_filter['the_content']){
			$priorities = array_keys($wp_filter['the_content']);
			foreach($priorities as $priority){
				if ($priority > 11){
						foreach ($wp_filter['the_content'][$priority] as $key => $value){
							try{
								if (is_array($value['function'])){
									$func = new ReflectionMethod($value['function'][0], $value['function'][1]);
								} else {
									$func = new ReflectionFunction($key);
								}
								$suspects []= $func;
							} catch (Exception $e){
								
							} 
						}
				}
			}
		}
		if ($suspects){
			$messages = array();
			foreach ($suspects as $suspect){
				$messages []= sprintf(__('File %s, line %s', 'uber-grid'), $suspect->getFileName(), $suspect->getStartLine());
			}
			$this->show_problem(sprintf(__("UberGrid has detected a potentionally incompatible theme. If your grids will have spacing or other issues - please open the <a href='%s'>settings page</a> and enable \"Use shortcode hack\" option.", 'uber-grid'), admin_url('options-general.php?page=uber-grid-options')));
		}
	}
	
	function show_problem($problem){
		?><div class="error"><p><?php echo sprintf(__('<strong>Message from UberGrid:</strong> %s', 'usernoise'), $problem) ?></p></div><?php 
	}
	
}

new UberGrid_Diagnostics;
