<?php
//------------------------------------------------------------------------------------
//status:               CHECKED IN
//------------------------------------------------------------------------------------
/**
 * cls_htmlelements.php
 * @package plugins_shared
 * @version version 1.4.0
 * @copyright EIP Software LLC - eipSoftware_Copyright.php
 */
//------------------------------------------------------------------------------------

/**
 * classes to handle creating HTML elements
 * @return string html
 */
class HTML_Elements
{
//------------------------------------------------------------------------------------
//Anticipated Args
//		AppenedNewLine				//when writing to browser append "\n" to the line item
//		PrefixTabs					//how many tabs to prefix to the open tag			
//		tag_OpenStart				//start of the html tag
//		tag_OpenEnd					//ending part of the Open tag
//		tag_Close					//how to close the tag
//		ShowPriorInput				//boolean value on whether to keep the previous args or overwrite them
//------------------------------------------------------------------------------------
//	All Elements	
//					id				//id for the element
//					text			//is plain text you want to display between the html tags
//	Tables Args
//					columns			//number of columns the table will have
//					header			//is this row a table header row
//					footer			// is this a table footer row
//	Select Boxes
//					selectedoption	//Which option is currently selected		
//		
//------------------------------------------------------------------------------------
	
	protected	$ShowPriorInput =	true;												//we will keep the prior input
	protected	$tag_OpenStart	=	"<";												//opening part of the html tag 
	protected	$tag_OpenEnd	=	">";												//closing part of the html tag
	protected	$tag_Close		=	"</>";												//tag to appened to the end of the html		
	protected	$AppendNewLine	=	"";													//what to append before starting a new line
	protected	$PrefixNewLine	=	0;
	protected	$PrefixIndent	=	0;
	protected 	$arr_SkipValue	=	Array("text","columns","selectedoption","header");	//don't echo these value pairs
	protected 	$arr_HideKey	=	Array("code","text","columns");						//don't echo the key for the value pair
	
	protected	$args			=	Array();											//hold the usr input args
	protected	$html_Element;															//html string returned by getElement
	
	
	public function	__construct($args)
	{
		if(is_array($args))
		{
			$this->ProcessArgs($args);													//when the object is built, lets process the args
			$this->BuildElement();
		}
	}
	 
	protected function ProcessArgs($args)
	{
		if(is_array($args)){$this->args = array_merge($this->args,$args);};				//merge the args into the obj's args array
		switch (get_class($this))														//set the conditions
		{
			case "Link":
			{
				$this->SetTags("<a",">","</a>",0,1,0);break;
			}
			case "Table":
			{
				$this->SetTags("<table",">","",1,1,1);break;	
			}
			case "Row":
			{
				$this->SetTags("<tr",">","</tr>",1,2,0);break;
			}
			case "Cell":
			{
				$tag = ((array_key_exists("header", $this->args)) && ($this->args['header'] == true)) ? "th" :"td";
				$this->SetTags("<".$tag ,">","</".$tag.">",1,3,1);break;		
			}
			case "SelectBox" :
			{
				$this->SetTags("<Select",">","",1,1,1);break;	
			}
			case "Option" :
			{
				$this->SetTags("<option",">","</option>",1,2,1);break;
			}
		}
		
	}
	//-----------------------------------------
	//set the tags for the element
	//-----------------------------------------
	private function SetTags($str_OpenTag,$str_EndTag,$str_CloseTag,$int_PrefixLines=0,$int_Tabs=0,$int_AppendLines=0)
	{
		$this->tag_OpenStart	= $str_OpenTag;								//how to open the html tag
		$this->tag_OpenEnd 		= $str_EndTag;								//how to close the opening html tag
		$this->tag_Close 		= $str_CloseTag;							//if there is a closing html tag
		$this->PrefixNewLine	= str_repeat("\n", $int_PrefixLines);		//number of new lines to prefix to the tag
		$this->PrefixIndent 	= str_repeat("\t", $int_Tabs);				//how many tab spaces to indent
		$this->AppendNewLine 	= str_repeat("\n", $int_AppendLines);		//number of new lines to append to the tag
	}
	//-----------------------------------------
	//Build the html element
	//-----------------------------------------
	protected function BuildElement($ReturnResult=false)
	{
		$str_Temp = "";
		if(count($this->args)>0)														//is there anything inside the array?
		{
			foreach($this->args as $fe_key_Element=>$fe_val_Element)					//cycle through each arg and add or disregard the arg
			{
				$str_Temp .= (is_null($fe_val_Element)==false)
							? (in_array($fe_key_Element,$this->arr_SkipValue)==false)	//if its a value pair we want to skip
							? (in_array($fe_key_Element,$this->arr_HideKey))			//value pair we want to suppress key value
							? $fe_val_Element : " ". $fe_key_Element."='".$fe_val_Element."'": "" : "";		//when creating the element string
			}
			$this->html_Element = $this->PrefixNewLine . $this->PrefixIndent . $this->tag_OpenStart . $str_Temp .
								  $this->tag_OpenEnd . $this->args['text'] . $this->tag_Close;	//append the opening and closing tags for the element			
		}
		if($ReturnResult){return($this->html_Element);}
	}
	//-----------------------------------------
	//return the html element
	//-----------------------------------------
	public function getElement($NewArgs=null,$ShowPriorInput=true)
	{
		if(is_array($NewArgs))
		{
			if(!$ShowPriorInput){$this->args = null;}
			$this->ProcessArgs($NewArgs);
			$this->BuildElement();
		}
		switch (get_class($this))											//additional processing required?
		{
			case "Table":
			{
				$this->html_Element .= $this->BuildCells()."\n\t</table>\n";break;
			}
			case "SelectBox":
			{
				$this->html_Element .= $this->BuildOptions()."\n\t</select>\n";break;
			}
		}
		return($this->html_Element);
	}
}
//----------------------------------------------------------------------------------------------------------------------------
//LINKS			//<a href> html link	
//invoke:		$html_Link = New Link(Array("href"=>"http://www.abc.com","text"=>"Simple Link"));
//----------------------------------------------------------------------------------------------------------------------------
class Link extends HTML_Elements
{	
	//build a simple html link	
}
//----------------------------------------------------------------------------------------------------------------------------
//TABLE			//<table> html Table
//invoke:		$html_Tbl = New Table(Array(id=>"id_Tbl1","class"=>"cls_T1","columns"=>3));
//----------------------------------------------------------------------------------------------------------------------------
class Table extends HTML_Elements
{
	public $Rows	= 	Array();				//collection to hold all the row elements
	public $Cells	= 	Array();				//collection to hold all the cell elements
	
	protected function BuildCells()
	{
		$ctrRow 	= 0;
		$ctrCol 	= 1;
		$ctrRows	= Count($this->Rows);										//how many rows are in the collection
		$ctrCells 	= Count($this->Cells);										//how many cells are in the collection
		$cntCols	= ($this->args['columns']>0) ? $this->args['columns'] : 1;	//how many cols in the table, default == 1
		$str_Temp	= ($ctrRows<1) ?  "\n\t\t<tr>" : $this->Rows[$ctrRow]->BuildElement(true);
		foreach($this->Cells as $fe_Cells)										//cycle through the entire array
		{
			$str_Temp .= $fe_Cells->BuildElement(true);							//build the element -- a table cell	
			if($ctrCol % $cntCols == 0)											//starting a new row?
			{
				$str_Temp .= "\n\t\t</tr>";								//close the row
				if($ctrRows>=1 && $ctrRow < $ctrRows)
				{
					$str_Temp .= $this->Rows[$ctrRow]->BuildElement(true);	//usr defined row element
					$ctrRow++;	
				}
				elseif($ctrCol<$ctrCells)
				{
					$str_Temp .= "\n\t\t<tr>";							//default row element
				}
			}
			$ctrCol++;													//how many cols have we built in this row?
		}
		return($str_Temp);
	}
}
//----------------------------------------------------------------------------------
//TABLE Row		//<tr> html table rows
//invoke:		array_push($html_Tbl->Cells, New Cell(array('id'=>'id'.$ctr1,"class"=>"tdclass",text=>"cell".$ctr1)));
//----------------------------------------------------------------------------------
class Row extends HTML_Elements
{
		//normally a collection of Rows will be used with the table class
}
//----------------------------------------------------------------------------------
//TABLE Cell	//<th> or <td> html table cells
//invoke:		array_push($html_Tbl->Cells, New Cell(array('id'=>'id'.$ctr1,"class"=>"tdclass",text=>"cell".$ctr1)));
//----------------------------------------------------------------------------------
class Cell extends HTML_Elements
{
	//normally a collection of cells will be used with the table class
}
class Div extends HTML_Elements
{
	//divs to hold the data elements	
}
//----------------------------------------------------------------------------------------------------------------------------
//SELECT BOXES
//----------------------------------------------------------------------------------------------------------------------------
class SelectBox extends HTML_Elements
{
	public $Options =	Array();					//collection to hold all the cell elements
	protected function BuildOptions()
	{
		foreach($this->Options as $fe_Opt)
		{
			$str_Temp .= $fe_Opt->BuildElement(true);	//build the options	
		}
		
		if($this->args['selectedoption'])
		{
			$int_StartPos = strpos($str_Temp,$this->args['selectedoption']);
			if($int_StartPos>3)
			{
				$int_EndPos = strpos($str_Temp, ">",$int_StartPos);
				$str_Sel = " selected=\"selected\">";
				$str_Temp = substr_replace($str_Temp, $str_Sel, $int_EndPos, 1);
			}
		}
		return($str_Temp);
	}
}
//----------------------------------------------------------------------------------
//SELECT Option		//option for the select boxes
//----------------------------------------------------------------------------------
class Option extends HTML_Elements
{
	//normally a collection of options to be used with the SelectBoxs class	
}
//----------------------------------------------------------------------------------------------------------------------------
//INPUT BOXES
//----------------------------------------------------------------------------------------------------------------------------
?>