<?php
/*
Plugin Name: eipSoftware Get Latest Posts
Plugin URI: http://www.eipsoftware.com/
Description: Get X number of last posts from Xenforo forum software
Author: eipSoftware
Version: version 1.3.0
Author URI: http://www.eipsoftware.com/
*/
//----------------------------------------------------------------------------------------------------------------------------
/** 
 * Get Forum Last Posts
 * @package plugins_lastposts
 * @version version 1.4.0
 * @copyright EIP Software LLC - eipSoftware_Copyright.php
 */
//----------------------------------------------------------------------------------------------------------------------------
//GLOBALS
//----------------------------------------------------------------------------------------------------------------------------
// Make sure file isn't being called directly.
if (!function_exists('add_action')) 
{
	echo("This is the Get Forum Last Post plugin for wordpress; use the wordpress plugin manager to update the options");
	exit;
}
if(is_admin())
{
	$curr_dir = dirname( __FILE__ );
	include_once $curr_dir . '/shared/supportFunctions.php';
	include_once $curr_dir . '/shared/adminFunctions.php';
	require_once $curr_dir . '/lastposts/getForumLastPostAdmin.php';
}

//store the action in the queue
add_action("plugins_loaded", "eipLastPostsRegister");
add_action('wp_print_styles', 'addLastPostStyle');
//----------------------------------------------------------------------------------------------------------------------------
	/**
	 * 
	 * initialize and register the widget
	 */
	function eipLastPostsRegister()
	{
		wp_register_sidebar_widget("eipGLP", "eip Last Posts","eipGetLastPosts");
	}
	function addLastPostStyle()
	{
		wp_register_style("eipGLPStyle", WP_PLUGIN_URL . "/eipSoftware/lastposts/styles/style_lastpost.css");
		wp_enqueue_style("eipGLPStyle", dirname(__FILE__) ."/styles/style_lastpost.css", false, 'version 1.3.0', 'all' ); // Inside a plugin
	}
	function eipGetLastPosts()
	{
		$curr_dir = dirname( __FILE__ )."/lastposts";
		$shared_dir = dirname( __FILE__ )."/shared";		
		//shared files
		include_once $shared_dir	. '/cls/cls_errorhandler.php';
		include_once $shared_dir	. '/cls/cls_xfconfig.php';
		include_once $shared_dir	. '/cls/cls_htmlelements.php';
		include_once $shared_dir	. '/qry/qry_privatenodelist.php';
		//last posts files
		include_once $curr_dir . '/cls/cls_footertable.php';
		include_once $curr_dir . '/cls/cls_sidebartable.php';
		include_once $curr_dir . '/cls/cls_sidebarlist.php';
		include_once $curr_dir . '/cls/cls_getlastposts.php';
		include_once $curr_dir . '/qry/qry_lastposts.php';
		include_once $curr_dir . '/qry/qry_lastpostslist.php';
		$lastPosts = new getLastPosts;
		echo($lastPosts->getForumData());
		unset($lastPosts);
	}
	function eipGetLastPosts_control()
	{
		return;
	}
?>