<?php

class XenGallery_ViewPublic_Media_View extends XenForo_ViewPublic_Base
{
	public function renderHtml()
	{
		if (!empty($this->_params['canAddComment']))
		{
			$this->_params['commentsEditor'] = XenForo_ViewPublic_Helper_Editor::getQuickReplyEditor($this, 'media_comment');
		}
		
		$bbCodeParser = new XenForo_BbCode_Parser(XenForo_BbCode_Formatter_Base::create('Base', array('view' => $this)));
		
		$videoHtml = new XenForo_BbCode_TextWrapper($this->_params['media']['media_tag'], $bbCodeParser);
		$captionHtml = new XenForo_BbCode_TextWrapper($this->_params['media']['media_caption'], $bbCodeParser);
		
		$this->_params += array(
			'videoHtml' => $videoHtml,
			'captionHtml' => $captionHtml
		);		
		
		$comments = $this->_params['comments'];
		
		foreach ($comments AS $key => &$comment)
		{
			$comments[$key]['media_comment'] = new XenForo_BbCode_TextWrapper($comments[$key]['media_comment'], $bbCodeParser);
		}
		
		$this->_params['comments'] = $comments;			
	}
}