<?php
						
class Waindigo_PostAsUser_Model_User extends XFCP_Waindigo_PostAsUser_Model_User
{
	public function getUsersByUserGroupIds(array $userGroupIds, $conditions = array(), $fetchOptions = array())
	{
		$whereClause = $this->prepareUserConditions($conditions, $fetchOptions);
		
		$db = $this->_getDb();
		$groupConds[] = 'user.user_group_id IN (' . $db->quote($userGroupIds) . ')';
		foreach ($userGroupIds AS $groupId)
		{
			$groupConds[] = 'FIND_IN_SET(' . $db->quote($groupId) . ', user.secondary_group_ids)';
		}
		return $this->fetchAllKeyed('
			SELECT user.*
			FROM xf_user AS user
			WHERE ' . $whereClause . '
			    AND (' . implode(' OR ', $groupConds) . ')
		    ORDER BY username ASC
		', 'user_id');
	}

	/**
	 * Determines if the viewing user can post as a different user.
	 *
	 * @param string $errorPhraseKey By ref. More specific error, if available.
	 * @param array|null $viewingUser Viewing user reference
	 *
	 * @return boolean
	 */
	public function canPostAsDifferentUser(&$errorPhraseKey = '', array $viewingUser = null)
	{
		$this->standardizeViewingUserReference($viewingUser);
		return ($viewingUser['user_id'] && XenForo_Permission::hasPermission($viewingUser['permissions'], 'general', 'postAsDifferentUser'));
	} /* END Waindigo_FirstColReports_Extend_XenForo_Model_User::canViewTerms */
}