<?php

abstract class Waindigo_Listener_TemplateHook extends Waindigo_Listener_Template
{
    protected $_hookName = null;
	protected $_hookParams = null;
	protected $_viewParams = null;

	/**
	 * @see Waindigo_Listener_Template::run()
	 */
	public function run()
	{
		switch ($this->_hookName)
		{
			case 'page_container_breadcrumb_bottom':
				if (!self::$_copyrightNotice) $this->_copyrightNotice();
				break;
		}
		return parent::run();
	} /* END Waindigo_Listener_TemplateHook::run */
			
	/**
	 * @param string $hookName
	 * @param string $contents.
	 * @param array $hookParams
	 * @param XenForo_Template_Abstract $template
	 */
	public function __construct($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template) {
		$this->_hookName = $hookName;
		$this->_hookParams = $hookParams;
		parent::__construct($contents, $template);
	} /* END Waindigo_Listener_TemplateHook::__construct */
			
	/**
	 * Called whenever a template hook is encountered (via <xen:hook> tags).
	 * You may use this event to modify the final output of that portion of the
	 * template.
	 * 
	 * A template hook may pass a block of final template output with it; you 
	 * may either adjust this text (such as with regular expressions) or add 
	 * additional output before or after the contents. Some blocks will not
	 * pass contents with them; they are primarily designed to allow you to add
	 * additional components in those positions.
	 * 
	 * @param string $hookName - the name of the template hook being called
	 * @param string $contents - the contents of the template hook block. This
	 *     content will be the final rendered output of the block. You should 
	 *     manipulate this, such as by adding additional output at the end.
	 * @param array $hookParams - explicit key-value params that have been
	 *     passed to the hook, enabling content-aware decisions. These will not
	 *     be all the params that are available to the template.
	 * @param XenForo_Template_Abstract $template - the raw template object
	 *     that has called this hook. You can access the template name and
	 *     full, raw set of parameters via this object.
	 */
	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
    	// This only works on PHP 5.3+, so method should be overridden for now
	    $class = get_called_class();
		$templateHook = new $class($hookName, $contents, $hookParams, $template);
		$contents = $templateHook->run();
	} /* END Waindigo_Listener_TemplateHook::templateHook */
		
	/**
	 * @see Waindigo_Listener_Template::_fetchViewParams()
	 */
	protected function _fetchViewParams()
	{
		if (!$this->_viewParams)
		{
			$this->_viewParams = array_merge($this->_template->getParams(), $this->_hookParams);
		}
		return $this->_viewParams;
	} /* END Waindigo_Listener_TemplateHook::_fetchViewParams */
			
	protected final function _copyrightNotice()
	{
		$this->_prepend(self::$copyrightNotice);
		self::$_copyrightNotice = true;
	} /* END Waindigo_Listener_TemplateHook::_copyrightNotice */
	
	/**
	 * Template name: account_alert_preferences
	 * Since version: 1.0.0
	 */
	protected function _accountAlertsMessagesInThreads()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountAlertsMessagesInThreads */

	/**
	 * Template name: account_alert_preferences
	 * Since version: 1.0.0
	 */
	protected function _accountAlertsMessagesOnProfilePages()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountAlertsMessagesOnProfilePages */

	/**
	 * Template name: account_alert_preferences
	 * Since version: 1.0.0
	 */
	protected function _accountAlertsAchievements()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountAlertsAchievements */

	/**
	 * Template name: account_alert_preferences
	 * Since version: 1.0.0
	 */
	protected function _accountAlertsExtra()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountAlertsExtra */

	/**
	 * Template name: account_contact_details
	 * Since version: 1.0.0
	 */
	protected function _accountContactDetailsEmailPassword()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountContactDetailsEmailPassword */

	/**
	 * Template name: account_contact_details
	 * Since version: 1.0.0
	 */
	protected function _accountContactDetailsMessaging()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountContactDetailsMessaging */

	/**
	 * Template name: account_contact_details
	 * Since version: 1.0.0
	 */
	protected function _accountContactDetailsIdentities()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountContactDetailsIdentities */

	/**
	 * Template name: account_facebook
	 * Since version: 1.0.0
	 */
	protected function _accountFacebookAssociated()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountFacebookAssociated */

	/**
	 * Template name: account_facebook
	 * Since version: 1.0.0
	 */
	protected function _accountFacebookNotAssociated()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountFacebookNotAssociated */

	/**
	 * Template name: account_following
	 * Since version: 1.0.0
	 * 
	 * Before 1.1.3, this hook was used instead of account_ignored_memberlist
	 * @see Waindigo_Listener_TemplateHook::_accountIgnoredMemberlist
	 */
	protected function _accountFollowingMemberlist()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountFollowingMemberlist */

	/**
	 * Template name: account_following
	 * Since version: 1.0.0
	 */
	protected function _accountFollowingControls()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountFollowingControls */

	/**
	 * Template name: account_personal_details
	 * Since version: 1.0.0
	 */
	protected function _accountPersonalDetailsStatus()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountPersonalDetailsStatus */

	/**
	 * Template name: account_personal_details
	 * Since version: 1.0.0
	 */
	protected function _accountPersonalDetailsBiometrics()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountPersonalDetailsBiometrics */

	/**
	 * Template name: account_personal_details
	 * Since version: 1.0.0
	 */
	protected function _accountPersonalDetailsInformation()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountPersonalDetailsInformation */

	/**
	 * Template name: account_personal_details
	 * Since version: 1.0.0
	 */
	protected function _accountPersonalDetailsAbout()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountPersonalDetailsAbout */

	/**
	 * Template name: account_preferences
	 * Since version: 1.0.0
	 */
	protected function _accountPreferencesAppearance()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountPreferencesAppearance */

	/**
	 * Template name: account_preferences
	 * Since version: 1.0.0
	 */
	protected function _accountPreferencesLocale()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountPreferencesLocale */

	/**
	 * Template name: account_preferences
	 * Since version: 1.0.0
	 */
	protected function _accountPreferencesOptions()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountPreferencesOptions */

	/**
	 * Template name: account_privacy
	 * Since version: 1.0.0
	 */
	protected function _accountPrivacyTop()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountPrivacyTop */

	/**
	 * Template name: account_privacy
	 * Since version: 1.0.0
	 */
	protected function _accountPrivacyPersonalDetails()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountPrivacyPersonalDetails */

	/**
	 * Template name: account_privacy
	 * Since version: 1.0.0
	 */
	protected function _accountPrivacyNewsFeed()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountPrivacyNewsFeed */

	/**
	 * Template name: account_privacy
	 * Since version: 1.0.0
	 */
	protected function _accountPrivacyContactDetails()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountPrivacyContactDetails */

	/**
	 * Template name: account_privacy
	 * Since version: 1.0.0
	 */
	protected function _accountPrivacyBottom()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountPrivacyBottom */

	/**
	 * Template name: account_wrapper
	 * Since version: 1.0.0
	 */
	protected function _accountWrapperSidebar()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountWrapperSidebar */

	/**
	 * Template name: account_wrapper
	 * Since version: 1.0.0
	 */
	protected function _accountWrapperSidebarYourAccount()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountWrapperSidebarYourAccount */

	/**
	 * Template name: account_wrapper
	 * Since version: 1.0.0
	 */
	protected function _accountWrapperSidebarConversations()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountWrapperSidebarConversations */

	/**
	 * Template name: account_wrapper
	 * Since version: 1.0.0
	 */
	protected function _accountWrapperSidebarSettings()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountWrapperSidebarSettings */

	/**
	 * Template name: account_wrapper
	 * Since version: 1.0.0
	 */
	protected function _accountWrapperContent()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountWrapperContent */

	/**
	 * Template name: ad_above_content
	 * Since version: 1.0.0
	 */
	protected function _adAboveContent()
	{
	} /* END Waindigo_Listener_TemplateHook::_adAboveContent */

	/**
	 * Template name: ad_above_top_breadcrumb
	 * Since version: 1.0.0
	 */
	protected function _adAboveTopBreadcrumb()
	{
	} /* END Waindigo_Listener_TemplateHook::_adAboveTopBreadcrumb */

	/**
	 * Template name: ad_below_content
	 * Since version: 1.0.0
	 */
	protected function _adBelowContent()
	{
	} /* END Waindigo_Listener_TemplateHook::_adBelowContent */

	/**
	 * Template name: ad_below_top_breadcrumb
	 * Since version: 1.0.0
	 */
	protected function _adBelowTopBreadcrumb()
	{
	} /* END Waindigo_Listener_TemplateHook::_adBelowTopBreadcrumb */

	/**
	 * Template name: ad_forum_view_above_node_list
	 * Since version: 1.0.0
	 */
	protected function _adForumViewAboveNodeList()
	{
	} /* END Waindigo_Listener_TemplateHook::_adForumViewAboveNodeList */

	/**
	 * Template name: ad_forum_view_above_thread_list
	 * Since version: 1.0.0
	 */
	protected function _adForumViewAboveThreadList()
	{
	} /* END Waindigo_Listener_TemplateHook::_adForumViewAboveThreadList */

	/**
	 * Template name: ad_header
	 * Since version: 1.0.0
	 */
	protected function _adHeader()
	{
	} /* END Waindigo_Listener_TemplateHook::_adHeader */

	/**
	 * Template name: ad_member_view_above_messages
	 * Since version: 1.0.0
	 */
	protected function _adMemberViewAboveMessages()
	{
	} /* END Waindigo_Listener_TemplateHook::_adMemberViewAboveMessages */

	/**
	 * Template name: ad_member_view_below_avatar
	 * Since version: 1.0.0
	 */
	protected function _adMemberViewBelowAvatar()
	{
	} /* END Waindigo_Listener_TemplateHook::_adMemberViewBelowAvatar */

	/**
	 * Template name: ad_member_view_sidebar_bottom
	 * Since version: 1.0.0
	 */
	protected function _adMemberViewSidebarBottom()
	{
	} /* END Waindigo_Listener_TemplateHook::_adMemberViewSidebarBottom */

	/**
	 * Template name: ad_message_below
	 * Since version: 1.0.0
	 */
	protected function _adMessageBelow()
	{
	} /* END Waindigo_Listener_TemplateHook::_adMessageBelow */

	/**
	 * Template name: ad_message_body
	 * Since version: 1.0.0
	 */
	protected function _adMessageBody()
	{
	} /* END Waindigo_Listener_TemplateHook::_adMessageBody */

	/**
	 * Template name: ad_sidebar_below_visitor_panel
	 * Since version: 1.0.0
	 */
	protected function _adSidebarBelowVisitorPanel()
	{
	} /* END Waindigo_Listener_TemplateHook::_adSidebarBelowVisitorPanel */

	/**
	 * Template name: ad_sidebar_bottom
	 * Since version: 1.0.0
	 */
	protected function _adSidebarBottom()
	{
	} /* END Waindigo_Listener_TemplateHook::_adSidebarBottom */

	/**
	 * Template name: ad_sidebar_top
	 * Since version: 1.0.0
	 */
	protected function _adSidebarTop()
	{
	} /* END Waindigo_Listener_TemplateHook::_adSidebarTop */

	/**
	 * Template name: ad_thread_list_below_stickies
	 * Since version: 1.0.0
	 */
	protected function _adThreadListBelowStickies()
	{
	} /* END Waindigo_Listener_TemplateHook::_adThreadListBelowStickies */

	/**
	 * Template name: ad_thread_view_above_messages
	 * Since version: 1.0.0
	 */
	protected function _adThreadViewAboveMessages()
	{
	} /* END Waindigo_Listener_TemplateHook::_adThreadViewAboveMessages */

	/**
	 * Template name: ad_thread_view_below_messages
	 * Since version: 1.0.0
	 */
	protected function _adThreadViewBelowMessages()
	{
	} /* END Waindigo_Listener_TemplateHook::_adThreadViewBelowMessages */

	/**
	 * Template name: editor
	 * Since version: 1.0.0
	 */
	protected function _editor()
	{
	} /* END Waindigo_Listener_TemplateHook::_editor */

	/**
	 * Template name: editor_js_setup
	 * Since version: 1.0.0
	 */
	protected function _editorJsSetup()
	{
	} /* END Waindigo_Listener_TemplateHook::_editorJsSetup */

	/**
	 * Template name: editor_js_setup
	 * Since version: 1.0.0
	 */
	protected function _editorTinymceInit()
	{
	} /* END Waindigo_Listener_TemplateHook::_editorTinymceInit */

	/**
	 * Template name: footer
	 * Since version: 1.0.0
	 */
	protected function _footer()
	{
	} /* END Waindigo_Listener_TemplateHook::_footer */

	/**
	 * Template name: footer
	 * Since version: 1.0.0
	 */
	protected function _footerLinks()
	{
	} /* END Waindigo_Listener_TemplateHook::_footerLinks */

	/**
	 * Template name: footer
	 * Since version: 1.0.0
	 */
	protected function _footerLinksLegal()
	{
	} /* END Waindigo_Listener_TemplateHook::_footerLinksLegal */

	/**
	 * Template name: forum_list
	 * Since version: 1.0.0
	 */
	protected function _forumListNodes()
	{
	} /* END Waindigo_Listener_TemplateHook::_forumListNodes */

	/**
	 * Template name: forum_list
	 * Since version: 1.0.0
	 */
	protected function _forumListSidebar()
	{
	} /* END Waindigo_Listener_TemplateHook::_forumListSidebar */

	/**
	 * Template name: forum_view
	 * Since version: 1.0.0
	 */
	protected function _forumViewPagenavBefore()
	{
	} /* END Waindigo_Listener_TemplateHook::_forumViewPagenavBefore */

	/**
	 * Template name: forum_view
	 * Since version: 1.0.0
	 */
	protected function _forumViewThreadsBefore()
	{
	} /* END Waindigo_Listener_TemplateHook::_forumViewThreadsBefore */

	/**
	 * Template name: header
	 * Since version: 1.0.0
	 */
	protected function _header()
	{
	} /* END Waindigo_Listener_TemplateHook::_header */

	/**
	 * Template name: logo_block
	 * Since version: 1.0.0
	 */
	protected function _headerLogo()
	{
	} /* END Waindigo_Listener_TemplateHook::_headerLogo */

	/**
	 * Template name: member_card
	 * Since version: 1.0.0
	 */
	protected function _memberCardLinks()
	{
	} /* END Waindigo_Listener_TemplateHook::_memberCardLinks */

	/**
	 * Template name: member_card
	 * Since version: 1.0.0
	 * @deprecated
	 */
	protected function _memberCardStats1()
	{
	} /* END Waindigo_Listener_TemplateHook::_memberCardStats1 */

	/**
	 * Template name: member_card
	 * Since version: 1.0.0
	 * @deprecated
	 */
	protected function _memberCardStats2()
	{
	} /* END Waindigo_Listener_TemplateHook::_memberCardStats2 */

	/**
	 * Template name: member_view
	 * Since version: 1.0.0
	 */
	protected function _memberViewSidebarStart()
	{
	} /* END Waindigo_Listener_TemplateHook::_memberViewSidebarStart */

	/**
	 * Template name: member_view
	 * Since version: 1.0.0
	 */
	protected function _memberViewSidebarMiddle1()
	{
	} /* END Waindigo_Listener_TemplateHook::_memberViewSidebarMiddle1 */

	/**
	 * Template name: member_view
	 * Since version: 1.0.0
	 */
	protected function _memberViewSidebarMiddle2()
	{
	} /* END Waindigo_Listener_TemplateHook::_memberViewSidebarMiddle2 */

	/**
	 * Template name: member_view
	 * Since version: 1.0.0
	 */
	protected function _memberViewSidebarEnd()
	{
	} /* END Waindigo_Listener_TemplateHook::_memberViewSidebarEnd */

	/**
	 * Template name: member_view
	 * Since version: 1.0.0
	 */
	protected function _memberViewTabsHeading()
	{
	} /* END Waindigo_Listener_TemplateHook::_memberViewTabsHeading */

	/**
	 * Template name: member_view
	 * Since version: 1.0.0
	 */
	protected function _memberViewTabsContent()
	{
	} /* END Waindigo_Listener_TemplateHook::_memberViewTabsContent */

	/**
	 * Template name: message
	 * Since version: 1.0.0
	 */
	protected function _messageNotices()
	{
	} /* END Waindigo_Listener_TemplateHook::_messageNotices */

	/**
	 * Template name: message
	 * Since version: 1.0.0
	 */
	protected function _messageContent()
	{
	} /* END Waindigo_Listener_TemplateHook::_messageContent */

	/**
	 * Template name: message_user_info
	 * Since version: 1.0.0
	 */
	protected function _messageUserInfoAvatar()
	{
	} /* END Waindigo_Listener_TemplateHook::_messageUserInfoAvatar */

	/**
	 * Template name: message_user_info
	 * Since version: 1.0.0
	 */
	protected function _messageUserInfoText()
	{
	} /* END Waindigo_Listener_TemplateHook::_messageUserInfoText */

	/**
	 * Template name: message_user_info
	 * Since version: 1.0.0
	 */
	protected function _messageUserInfoExtra()
	{
	} /* END Waindigo_Listener_TemplateHook::_messageUserInfoExtra */

	/**
	 * Template name: moderator_bar
	 * Since version: 1.0.0
	 */
	protected function _moderatorBar()
	{
	} /* END Waindigo_Listener_TemplateHook::_moderatorBar */

	/**
	 * Template name: navigation
	 * Since version: 1.0.0
	 */
	protected function _navigationTabsForums()
	{
	} /* END Waindigo_Listener_TemplateHook::_navigationTabsForums */

	/**
	 * Template name: navigation
	 * Since version: 1.0.0
	 */
	protected function _navigationTabsMembers()
	{
	} /* END Waindigo_Listener_TemplateHook::_navigationTabsMembers */

	/**
	 * Template name: navigation
	 * Since version: 1.0.0
	 */
	protected function _navigationTabsHelp()
	{
	} /* END Waindigo_Listener_TemplateHook::_navigationTabsHelp */

	/**
	 * Template name: navigation_visitor_tab
	 * Since version: 1.0.0
	 */
	protected function _navigationVisitorTabsStart()
	{
	} /* END Waindigo_Listener_TemplateHook::_navigationVisitorTabsStart */

	/**
	 * Template name: navigation_visitor_tab
	 * Since version: 1.0.0
	 */
	protected function _navigationVisitorTabLinks1()
	{
	} /* END Waindigo_Listener_TemplateHook::_navigationVisitorTabLinks1 */

	/**
	 * Template name: navigation_visitor_tab
	 * Since version: 1.0.0
	 */
	protected function _navigationVisitorTabLinks2()
	{
	} /* END Waindigo_Listener_TemplateHook::_navigationVisitorTabLinks2 */

	/**
	 * Template name: navigation_visitor_tab
	 * Since version: 1.0.0
	 */
	protected function _navigationTabsAccount()
	{
	} /* END Waindigo_Listener_TemplateHook::_navigationTabsAccount */

	/**
	 * Template name: navigation_visitor_tab
	 * Since version: 1.0.0
	 */
	protected function _navigationVisitorTabsMiddle()
	{
	} /* END Waindigo_Listener_TemplateHook::_navigationVisitorTabsMiddle */

	/**
	 * Template name: navigation_visitor_tab
	 * Since version: 1.0.0
	 */
	protected function _navigationVisitorTabsEnd()
	{
	} /* END Waindigo_Listener_TemplateHook::_navigationVisitorTabsEnd */

	/**
	 * Template name: PAGE_CONTAINER
	 * Since version: 1.0.0
	 */
	protected function _pageContainerHead()
	{
	} /* END Waindigo_Listener_TemplateHook::_pageContainerHead */

	/**
	 * Template name: PAGE_CONTAINER
	 * Since version: 1.0.0
	 */
	protected function _body()
	{
	} /* END Waindigo_Listener_TemplateHook::_body */

	/**
	 * Template name: PAGE_CONTAINER
	 * Since version: 1.0.0
	 */
	protected function _pageContainerContentTop()
	{
	} /* END Waindigo_Listener_TemplateHook::_pageContainerContentTop */

	/**
	 * Template name: PAGE_CONTAINER
	 * Since version: 1.0.0
	 */
	protected function _pageContainerNotices()
	{
	} /* END Waindigo_Listener_TemplateHook::_pageContainerNotices */

	/**
	 * Template name: PAGE_CONTAINER
	 * Since version: 1.0.0
	 */
	protected function _pageContainerBreadcrumbTop()
	{
	} /* END Waindigo_Listener_TemplateHook::_pageContainerBreadcrumbTop */

	/**
	 * Template name: PAGE_CONTAINER
	 * Since version: 1.0.0
	 */
	protected function _pageContainerContentTitleBar()
	{
	} /* END Waindigo_Listener_TemplateHook::_pageContainerContentTitleBar */

	/**
	 * Template name: PAGE_CONTAINER
	 * Since version: 1.0.0
	 */
	protected function _pageContainerSidebar()
	{
	} /* END Waindigo_Listener_TemplateHook::_pageContainerSidebar */

	/**
	 * Template name: PAGE_CONTAINER
	 * Since version: 1.0.0
	 */
	protected function _pageContainerBreadcrumbBottom()
	{
	} /* END Waindigo_Listener_TemplateHook::_pageContainerBreadcrumbBottom */

	/**
	 * Template name: page_container_js_body
	 * Since version: 1.0.0
	 */
	protected function _pageContainerJsBody()
	{
	} /* END Waindigo_Listener_TemplateHook::_pageContainerJsBody */

	/**
	 * Template name: search_bar
	 * Since version: 1.0.0
	 */
	protected function _quickSearch()
	{
	} /* END Waindigo_Listener_TemplateHook::_quickSearch */

	/**
	 * Template name: search_form_tabs
	 * Since version: 1.0.0
	 */
	protected function _searchFormTabs()
	{
	} /* END Waindigo_Listener_TemplateHook::_searchFormTabs */

	/**
	 * Template name: thread_create
	 * Since version: 1.0.0
	 */
	protected function _threadCreateFieldsMain()
	{
	} /* END Waindigo_Listener_TemplateHook::_threadCreateFieldsMain */

	/**
	 * Template name: thread_create
	 * Since version: 1.0.0
	 */
	protected function _threadCreateFieldsExtra()
	{
	} /* END Waindigo_Listener_TemplateHook::_threadCreateFieldsExtra */

	/**
	 * Template name: thread_list
	 * Since version: 1.0.0
	 */
	protected function _threadListStickies()
	{
	} /* END Waindigo_Listener_TemplateHook::_threadListStickies */

	/**
	 * Template name: thread_list
	 * Since version: 1.0.0
	 */
	protected function _threadListThreads()
	{
	} /* END Waindigo_Listener_TemplateHook::_threadListThreads */

	/**
	 * Template name: thread_list
	 * Since version: 1.0.0
	 */
	protected function _threadListOptions()
	{
	} /* END Waindigo_Listener_TemplateHook::_threadListOptions */

	/**
	 * Template name: thread_view
	 * Since version: 1.0.0
	 */
	protected function _threadViewPagenavBefore()
	{
	} /* END Waindigo_Listener_TemplateHook::_threadViewPagenavBefore */

	/**
	 * Template name: thread_view
	 * Since version: 1.0.0
	 */
	protected function _threadViewFormBefore()
	{
	} /* END Waindigo_Listener_TemplateHook::_threadViewFormBefore */

	/**
	 * Template name: thread_view
	 * Since version: 1.0.0
	 */
	protected function _threadViewQrBefore()
	{
	} /* END Waindigo_Listener_TemplateHook::_threadViewQrBefore */

	/**
	 * Template name: xenforo.css
	 * Since version: 1.0.0
	 */
	protected function _xenforoCssExtra()
	{
	} /* END Waindigo_Listener_TemplateHook::_xenforoCssExtra */
	
	/**
	 * Template name: ad_below_bottom_breadcrumb
	 * Since version: 1.0.1
	 */
	protected function _adBelowBottomBreadcrumb()
	{
	} /* END Waindigo_Listener_TemplateHook::_adBelowBottomBreadcrumb */
	
	/**
	 * Template name: member_card
	 * Since version: 1.0.1
	 */
	protected function _memberCardStats()
	{
	} /* END Waindigo_Listener_TemplateHook::_memberCardStats */

	/**
	 * Template name: sidebar_visitor_panel
	 * Since version: 1.0.1
	 */
	protected function _sidebarVisitorPanelStats()
	{
	} /* END Waindigo_Listener_TemplateHook::_sidebarVisitorPanelStats */
		
	/**
	 * Template name: account_alert_preferences
	 * Since version: 1.0.2
	 */
	protected function _accountAlertsAfterPosts()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountAlertsAfterPosts */
	
	/**
	 * Template name: account_alert_preferences
	 * Since version: 1.0.2
	 */
	protected function _accountAlertsAfterProfilePosts()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountAlertsAfterProfilePosts */
	
	/**
	 * Template name: conversation_message
	 * Since version: 1.0.2
	 */
	protected function _conversationMessagePrivateControls()
	{
	} /* END Waindigo_Listener_TemplateHook::_conversationMessagePrivateControls */
	
	/**
	 * Template name: conversation_message
	 * Since version: 1.0.2
	 */
	protected function _conversationMessagePublicControls()
	{
	} /* END Waindigo_Listener_TemplateHook::_conversationMessagePublicControls */
	
	/**
	 * Template name: member_recent_content
	 * Since version: 1.0.2
	 */
	protected function _memberRecentContentSearchContentTypes()
	{
	} /* END Waindigo_Listener_TemplateHook::_memberRecentContentSearchContentTypes */
	
	/**
	 * Template name: member_view
	 * Since version: 1.0.2
	 */
	protected function _memberViewInfoBlock()
	{
	} /* END Waindigo_Listener_TemplateHook::_memberViewInfoBlock */
	
	/**
	 * Template name: member_view
	 * Since version: 1.0.2
	 */
	protected function _memberViewSearchContentTypes()
	{
	} /* END Waindigo_Listener_TemplateHook::_memberViewSearchContentTypes */
	
	/**
	 * Template name: pagenode_container
	 * Since version: 1.0.2
	 */
	protected function _pagenodeContainerArticle()
	{
	} /* END Waindigo_Listener_TemplateHook::_pagenodeContainerArticle */
		
	/**
	 * Template name: post
	 * Since version: 1.0.2
	 */
	protected function _postPrivateControls()
	{
	} /* END Waindigo_Listener_TemplateHook::_postPrivateControls */
	
	/**
	 * Template name: post
	 * Since version: 1.0.2
	 */
	protected function _postPublicControls()
	{
	} /* END Waindigo_Listener_TemplateHook::_postPublicControls */
	
	/**
	 * Template name: profile_post
	 * Since version: 1.0.2
	 */
	protected function _profilePostPrivateControls()
	{
	} /* END Waindigo_Listener_TemplateHook::_profilePostPrivateControls */
	
	/**
	 * Template name: profile_post
	 * Since version: 1.0.2
	 */
	protected function _profilePostPublicControls()
	{
	} /* END Waindigo_Listener_TemplateHook::_profilePostPublicControls */

	/**
	 * Template name: thread_view
	 * Since version: 1.0.2
	 */
	protected function _threadViewQrAfter()
	{
	} /* END Waindigo_Listener_TemplateHook::_threadViewQrAfter */
	
	/**
	 * Template name: help_wrapper
	 * Since version: 1.0.3
	 */
	protected function _helpSidebarLinks()
	{
	} /* END Waindigo_Listener_TemplateHook::_helpSidebarLinks */
	
	/**
	 * Template name: share_page
	 * Since version: 1.0.3
	 */
	protected function _sharePageOptions()
	{
	} /* END Waindigo_Listener_TemplateHook::_sharePageOptions */
	
	/**
	 * Template name: sidebar_share_page
	 * Since version: 1.0.3
	 */
	protected function _sidebarSharePageOptions()
	{
	} /* END Waindigo_Listener_TemplateHook::_sidebarSharePageOptions */

	/**
	 * Template name: account_avatar
	 * Since version: 1.1.0
	 */
	protected function _accountAvatar()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountAvatar */
	
	/**
	 * Template name: account_ignored
	 * Since version: 1.1.0
	 */
	protected function _accountIgnoredControls()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountIgnoredControls */
	
	/**
	 * Template name: help_bb_codes
	 * Since version: 1.1.0
	 */
	protected function _helpBbCodes()
	{
	} /* END Waindigo_Listener_TemplateHook::_helpBbCodes */
	
	/**
	 * Template name: login_bar_form
	 * Since version: 1.1.0
	 */
	protected function _loginBarEauthSet()
	{
	} /* END Waindigo_Listener_TemplateHook::_loginBarEauthSet */
	
	/**
	 * Template name: login_bar_form
	 * Since version: 1.1.0
	 */
	protected function _loginBarEauthItems()
	{
	} /* END Waindigo_Listener_TemplateHook::_loginBarEauthItems */

	/**
	 * Template name: message_simple
	 * Since version: 1.1.0
	 */
	protected function _messageSimpleNotices()
	{
	} /* END Waindigo_Listener_TemplateHook::_messageSimpleNotices */

	/**
	 * Template name: message_user_info
	 * Since version: 1.1.0
	 */
	protected function _messageUserInfoCustomFields()
	{
	} /* END Waindigo_Listener_TemplateHook::_messageUserInfoCustomFields */

	/**
	 * Template name: node_forum_level_2
	 * Since version: 1.1.0
	 */
	protected function _nodeForumLevel2BeforeLastpost()
	{
	} /* END Waindigo_Listener_TemplateHook::_nodeForumLevel2BeforeLastpost */
	
	/**
	 * Template name: thread_create
	 * Since version: 1.1.0
	 */
	protected function _threadCreate()
	{
	} /* END Waindigo_Listener_TemplateHook::_threadCreate */
	
	/**
	 * Template name: thread_list_item
	 * Since version: 1.1.0
	 */
	protected function _threadListItemIconKey()
	{
	} /* END Waindigo_Listener_TemplateHook::_threadListItemIconKey */
	
	/**
	 * Template name: thread_reply
	 * Since version: 1.1.0
	 */
	protected function _threadReply()
	{
	} /* END Waindigo_Listener_TemplateHook::_threadReply */

	/**
	 * Template name: account_ignored
	 * Since version: 1.1.3
	 * 
	 * This hook replaces account_following_memberlist
	 * @see Waindigo_Listener_TemplateHook::_accountFollowingMemberlist
	 */
	protected function _accountIgnoredMemberlist()
	{
	} /* END Waindigo_Listener_TemplateHook::_accountIgnoredMemberlist */	
}