<?php

class Waindigo_Friends_Install extends Waindigo_Install
{
	protected function _getTables()
	{
		return array(
			'xf_friend' => array(
				'user_id'			=> 'INT(10) UNSIGNED NOT NULL',
				'friend_user_id'	=> 'INT(10) UNSIGNED NOT NULL',
				'message'			=> 'VARCHAR(255) NOT NULL',
				'friend_state'		=> 'ENUM(\'confirmed\',\'pending\',\'rejected\',\'\') NOT NULL DEFAULT \'\'',
				'since_date'		=> 'INT(10) UNSIGNED NOT NULL DEFAULT 0',
				'know_personally'	=> 'TINYINT(3) UNSIGNED NOT NULL DEFAULT 0',
			),
		);
	}
	
	protected function _getPrimaryKeys()
	{
		return array(
			'xf_friend' => array('user_id', 'friend_user_id'),
		);		
	}

	protected function _getTableChanges()
	{
		return array(
				'xf_user' => array(
						'friend_count'			=> 'INT(10) UNSIGNED NOT NULL DEFAULT \'0\'',
						'personal_friend_count' => 'INT(10) UNSIGNED NOT NULL DEFAULT \'0\'',
				),
		);
	}
	
	protected function _getContentTypes()
	{
		return array(
				'friend' => array(
						'addon_id' => 'Waindigo_Friends',
						'fields'   => array(
								'alert_handler_class' => 'Waindigo_Friends_AlertHandler_Friend',
						)
				),
		);
	}
	
}