<?php

class Waindigo_EmailIdleUsers_ControllerAdmin_EmailIdleUsersLog extends XenForo_ControllerAdmin_Log
{

    /**
     *
     * @return XenForo_ControllerResponse_Abstract
     */
    public function actionIndex()
    {
        $logModel = $this->_getEmailIdleUsersLogModel();

        $id = $this->_input->filterSingle('id', XenForo_Input::UINT);
        if ($id) {
            $entry = $logModel->getIdleUsersLogById($id);
            if (!$entry) {
                return $this->responseError(new XenForo_Phrase('requested_log_entry_not_found'), 404);
            }

            $viewParams = array(
                'entry' => $logModel->prepareIdleUsersLogEntry($entry)
            );
            return $this->responseView('XenForo_ViewAdmin_Log_ModeratorView', 'waindigo_log_user_view_emailidleusers',
                $viewParams);
        } else {
            $userId = 0;
            $username = $this->_input->filterSingle('username', XenForo_Input::STRING);
            if (!empty($username)) {
                $user = $this->_getUserModel()->getUserByName($username);
                if (!empty($user)) {
                    $userId = $user['user_id'];
                }
            }
            $page = $this->_input->filterSingle('page', XenForo_Input::UINT);
            $perPage = 20;

            $pageParams = array();
            if ($userId) {
                $pageParams['user_id'] = $userId;
            }

            $action = '';
            $entries = $logModel->getIdleUsersLogEntries($userId, $action,
                array(
                    'page' => $page,
                    'perPage' => $perPage
                ));

            $viewParams = array(
                'entries' => $logModel->prepareIdleUsersLogEntries($entries),
                'total' => $logModel->countIdleLogEntries($userId, $action),
                'page' => $page,
                'perPage' => $perPage,
                'pageParams' => $pageParams,
                'userId' => $userId,
                'logUsername' => $username
            );

            return $this->responseView('XenForo_ViewAdmin_Log_Moderator', 'waindigo_log_user_emailidleusers',
                $viewParams);
        }
    } /* END actionIndex */

    /**
     *
     * @return XenForo_ControllerResponse_Abstract
     */
    public function actionClear()
    {
        if ($this->isConfirmedPost()) {
            $this->_getEmailIdleUsersLogModel()->clearLog();

            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
                XenForo_Link::buildAdminLink('idle-users-logs/user'));
        } else {
            $viewParams = array();
            return $this->responseView('XenForo_ViewAdmin_Log_ServerErrorDelete', 'waindigo_log_clear_emailidleusers',
                $viewParams);
        }
    } /* END actionClear */

    /**
     *
     * @return XenForo_Model_User
     */
    protected function _getUserModel()
    {
        return $this->getModelFromCache('XenForo_Model_User');
    } /* END _getUserModel */

    /**
     *
     * @return Waindigo_EmailIdleUsers_Model_EmailIdleUsersLog
     */
    protected function _getEmailIdleUsersLogModel()
    {
        return $this->getModelFromCache('Waindigo_EmailIdleUsers_Model_EmailIdleUsersLog');
    } /* END _getEmailIdleUsersLogModel */
}