<?php

class RouteChanger_Listen
{
	public static function setRoutes(XenForo_Dependencies_Abstract $dependencies, array $data)
	{
		RouteChanger_Route_Static::$newIndex = false;

		if (isset($data['routesPublic']))
		{
			$rcRoutes = XenForo_Application::get('options')->rcRoutes;
			$origRoutes = $data['routesPublic'];
			$trackOld = array();
			$trackNew = array();

			foreach ($rcRoutes AS $key => $route)
			{
				if (empty($route['oldRoute']) OR empty($route['newRoute']))
				{
					continue;
				}

				// TRACK FOR CASES
				$trackOld[$route['oldRoute']] = $key;
				$trackNew[$route['newRoute']] = $key;

				if (
				isset($origRoutes[$route['oldRoute']])
				)
				{
					$data['routesPublic'][$route['newRoute']] = $origRoutes[$route['oldRoute']];
					$data['routesPublic'][$route['newRoute']]['build_link'] = 'all';
					$data['routesPublic'][$route['oldRoute']]['build_link'] = 'all';

					$class = $origRoutes[$route['oldRoute']]['route_class'];
					$buildLink = $origRoutes[$route['oldRoute']]['build_link'];

					RouteChanger_Route_Static::$newRoute[$class] = array(
						'prefix' => $route['newRoute'],
						'altprefix' => '',
						'index' => $key,
						'build_link' => $buildLink,
						'orig_build_link' => $buildLink, // NEEDED FOR A CASE BELOW TO ENSURE PROPER CASCADING OVER MULTIPLE MOVES
						'class' => $class,
						'origclass' => $class // NEEDED FOR A CASE BELOW TO ENSURE PROPER CASCADING OVER MULTIPLE MOVES
					);

					// DOUBLE ASSIGNMENT FOR EASY INDEXING
					RouteChanger_Route_Static::$newRoute[$key] =& RouteChanger_Route_Static::$newRoute[$class];

					// CASE:
					// A->B
					// B->C*
					// IF MOVING ROUTES AROUND, NOT SIMPLY RENAMING
					if (isset($trackNew[$route['oldRoute']]) AND isset($origRoutes[$route['oldRoute']]))
					{
						// MUST TELL B TO CREATE C LINKS USING C CLASS, WHILE B'S HANDLER IS STILL SET TO A CLASS
						RouteChanger_Route_Static::$newRoute[$trackNew[$route['oldRoute']]]['altprefix'] = $route['newRoute'];
						RouteChanger_Route_Static::$newRoute[$trackNew[$route['oldRoute']]]['class'] = $class;
						RouteChanger_Route_Static::$newRoute[$trackNew[$route['oldRoute']]]['build_link'] = $buildLink;
					}

					// CASE:
					// B->C
					// A->B*
					// IF MOVING ROUTES AROUND, NOT SIMPLY RENAMING
					if (isset($trackOld[$route['newRoute']]) AND isset($origRoutes[$route['newRoute']]))
					{
						// MUST TELL B TO CREATE C LINKS USING C CLASS, WHILE B'S HANDLER IS STILL SET TO A CLASS
						RouteChanger_Route_Static::$newRoute[$trackNew[$route['newRoute']]]['altprefix'] = RouteChanger_Route_Static::$newRoute[$trackOld[$route['newRoute']]]['prefix'];
						RouteChanger_Route_Static::$newRoute[$trackNew[$route['newRoute']]]['class'] = RouteChanger_Route_Static::$newRoute[$trackOld[$route['newRoute']]]['origclass'];
						RouteChanger_Route_Static::$newRoute[$trackNew[$route['newRoute']]]['build_link'] = RouteChanger_Route_Static::$newRoute[$trackOld[$route['newRoute']]]['orig_build_link'];
					}

					// IF WE HAVE CHANGED THE INDEX ROUTE THEN SET FLAG FOR CATEGORY LINK CHANGES
					if ($route['oldRoute'] == 'index')
					{
						RouteChanger_Route_Static::$newIndex = $route['newRoute'];
					}
				}
				else if (
				isset($origRoutes[$route['newRoute']])
				)
				{
					$data['routesPublic'][$route['oldRoute']] = $origRoutes[$route['newRoute']];
					$data['routesPublic'][$route['newRoute']]['build_link'] = 'all';
					$data['routesPublic'][$route['oldRoute']]['build_link'] = 'all';

					$class = $origRoutes[$route['newRoute']]['route_class'];
					$buildLink = $origRoutes[$route['newRoute']]['build_link'];

					RouteChanger_Route_Static::$newRoute[$class] = array(
						'prefix' => $route['newRoute'],
						'altprefix' => '',
						'index' => $key,
						'build_link' => $buildLink,
						'orig_build_link' => $buildLink,
						'class' => $class,
						'origclass' => $class
					);

					// DOUBLE ASSIGNMENT FOR EASY INDEXING
					RouteChanger_Route_Static::$newRoute[$key] =& RouteChanger_Route_Static::$newRoute[$class];
				}
			}

			XenForo_Link::setHandlerInfoForGroup('public', $data['routesPublic']);
		}
	}

	public static function changeLinks($class, array &$extend)
	{
		$newRoute =& RouteChanger_Route_Static::$newRoute;

		if (isset($newRoute[$class]))
		{
			$extend[] = "RouteChanger_Route_Prefix_{$newRoute[$class]['index']}";
		}

		if ($class == 'XenForo_Route_Prefix_Categories' AND RouteChanger_Route_Static::$newIndex AND !XenForo_Application::get('options')->categoryOwnPage)
		{
			$extend[] = "RouteChanger_Route_Prefix_Category";
		}
	}
}