<?php

class ProfileViewCount_Model_ViewCount extends XenForo_Model
{ 
    /**
    * Updates profile views in bulk.
    */
    public function updateProfileViews()
    {
        $db = $this->_getDb();
 
        $updates = $db->fetchPairs('
            SELECT user_id, COUNT(*)
            FROM xf_profile_view
            GROUP BY user_id
        ');
 
        XenForo_Db::beginTransaction($db);
 
        $db->query('TRUNCATE TABLE xf_profile_view');
 
        foreach ($updates AS $userId => $views)
        {
            $db->query('
                UPDATE xf_user_profile SET
                    view_count = view_count + ?
                WHERE user_id = ?
            ', array($views, $userId));
        }
 
        XenForo_Db::commit($db);
    }    
    
	public function getUsers(array $conditions, array $fetchOptions = array())
	{
		// Make use of existing methods in the User Model
		$userModel = XenForo_Model::create('XenForo_Model_User');
		
		$whereClause = $userModel->prepareUserConditions($conditions, $fetchOptions);

		$orderClause = $userModel->prepareUserOrderOptions($fetchOptions, 'view_count DESC');
		$joinOptions = $userModel->prepareUserFetchOptions($fetchOptions);
		$limitOptions = $userModel->prepareLimitFetchOptions($fetchOptions);

		return $this->fetchAllKeyed($this->limitQueryResults(
				'SELECT user.*
					' . $joinOptions['selectFields'] . '
				FROM xf_user AS user
				' . $joinOptions['joinTables'] . '
				WHERE ' . $whereClause . '
				' . $orderClause . '
			', $limitOptions['limit'], $limitOptions['offset']
		), 'user_id');
	}    
    
    public function getUserProfileViews($userId)
    {        
        return $this->_getDb()->fetchRow(
            	'SELECT
                        user.*,
                        user_profile.view_count
                FROM xf_user_profile AS user_profile
                INNER JOIN xf_user AS user ON
                        (user.user_id = user_profile.user_id)
                WHERE user.user_id = ?',
				$userId);
    }    
    
    public function resetProfileViews($userId)
    {   
    	if (!$userId)
    	{
    		return $this->_getDb()->query('
    			UPDATE `xf_user_profile` SET `view_count` = 0
    		');
		}
		else
		{
    		return $this->_getDb()->query('
    			UPDATE `xf_user_profile` SET `view_count` = 0 WHERE user_id = ' . $userId
    		);
		}
    }        
        
	public function getMostVisited($userLimit)
	{
        $result = $this->_getDb()->fetchAll('
                SELECT
                        user.username,
                        user.user_id,
                        user_profile.view_count
                FROM xf_user_profile AS user_profile
                INNER JOIN xf_user AS user ON
                        (user.user_id = user_profile.user_id)
                ORDER BY view_count DESC
                LIMIT ?
        ', $userLimit);
        
        return $result;		
	}
}
