<?php
class Brivium_ThreadsPostsOwner_Model_Owner extends XenForo_Model
{

	public function canChangeOwner(array $user = null)
	{
		$this->standardizeViewingUserReference($user);

		return XenForo_Permission::hasPermission($user['permissions'], 'forum', 'changeOwner');		
	}

	public function getTimeZoneOffset($user)
	{
		$defaultTimeZone = new DateTimeZone("Europe/London");
		$visitorTimeZone = new DateTimeZone($user['timezone']);

		$defaultTime = new DateTime("now", $defaultTimeZone);
		$visitorTime = new DateTime("now", $visitorTimeZone);

		return $visitorTimeZone->getOffset($defaultTime);	
	}
}