<?php
class Brivium_Credits_Model_Thread extends XFCP_Brivium_Credits_Model_Thread
{
	/**
	 * Marks the given thread as read up to a certain point (usually the most recent post read).
	 * Thread must have thread_read_date key. (Forum should have forum_read_date key.)
	 *
	 * @param array $thread Thread info
	 * @param array $forum Forum info
	 * @param integer $readDate Timestamp to mark
	 * @param array|null $viewingUser
	 *
	 * @return boolean True if marked as read
	 */
	public function markThreadRead(array $thread, array $forum, $readDate, array $viewingUser = null)
	{
		
		$result = parent::markThreadRead($thread,$forum,$readDate,$viewingUser);
		if(!isset($viewingUser['user_id'])){
			$this->standardizeViewingUserReference($viewingUser);
		}
		$userId = $viewingUser['user_id'];
		if($thread['user_id'] != $userId && (($userId && $result) ||(!$userId && XenForo_Application::get('options')->BRC_guestTriggerViewActions))){
		
			$errorString = '';
			if($userId){
				$dataCredit = array(
					'user' 			=>	$viewingUser,
					'node_id' 		=>	$thread['node_id'],
					'extraData' 	=>	array('thread_id'=>$thread['thread_id'])
				);
				$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('readThread',$userId,$dataCredit,$errorString);
			}
			if(!$errorString)
			{
				$dataCredit = array(
					'node_id' 			=>	$thread['node_id'],
					'extraData' 	=>	array('thread_id'=>$thread['thread_id'])
				);
				$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('threadViewed',$thread['user_id'],$dataCredit);
			}
		}
		return $result;
	}
	/**
	 * Get the time when a user has marked the given thread as read.
	 *
	 * @param integer $userId
	 * @param integer $threadId
	 *
	 * @return integer|null Null if guest; timestamp otherwise
	 */
	public function getUserThreadReadedDate($userId, $threadId)
	{
		if (!$userId)
		{
			return null;
		}
		return $this->_getDb()->fetchOne('
			SELECT thread_read_date
			FROM xf_thread_read
			WHERE user_id = ?
				AND thread_id = ?
		', array($userId, $threadId));
	}

	
}