<?php
class Brivium_Credits_Installer
{
	public static function addColumn($table, $field, $attr)
	{
		if (!self::checkIfExist($table, $field)) {
			$db = XenForo_Application::get('db');
			return $db->query("ALTER TABLE `" . $table . "` ADD `" . $field . "` " . $attr);
		}
	}

	public static function checkIfExist($table, $field)
	{
		$db = XenForo_Application::get('db');
		if ($db->fetchRow('SHOW columns FROM `' . $table . '` WHERE Field = ?', $field)) {
			return true;
		}
		else {
			return false;
		}
	}
	public static function install($existingAddOn, $addOnData)
	{
		$db = XenForo_Application::get('db');
		$db->query("
			CREATE TABLE IF NOT EXISTS `xf_credits_action` (
			  `action_id` varchar(100) NOT NULL,
			  `user_groups` mediumblob NOT NULL,
			  `forums` mediumblob NOT NULL,
			  `display_order` int(10) unsigned NOT NULL default '0',
			  `amount` double NOT NULL default '0',
			  `sub_amount` double NOT NULL default '0',
			  `multiplier` double NOT NULL default '1',
			  `sub_multiplier` double NOT NULL default '1',
			  `active` tinyint(1) unsigned NOT NULL default '1',
			  `alert` tinyint(1) unsigned NOT NULL default '1',
			  `times` int(10) unsigned NOT NULL default '1',
			  `max_time` int(11) unsigned NOT NULL default '0',
			  `apply_max` int(11) unsigned NOT NULL default '0',
			  `target` enum('user','user_action','both') NOT NULL default 'user',
			  `addon_id` varchar(25) NOT NULL,
			  `template` varchar(50) NOT NULL,
			  `global` tinyint(1) NOT NULL default '0',
			  PRIMARY KEY  (`action_id`)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8;
		");
		$db->query("
			CREATE TABLE IF NOT EXISTS `xf_credits_currency` (
			  `currency_id` int(11) unsigned NOT NULL auto_increment,
			  `title` varchar(50) NOT NULL,
			  `code` varchar(10) NOT NULL,
			  `symbol_left` varchar(12) NOT NULL,
			  `symbol_right` varchar(12) NOT NULL,
			  `decimal_place` tinyint(2) unsigned NOT NULL default '0',
			  `value` double(15,8) unsigned NOT NULL default '0.00000000',
			  `status` tinyint(1) unsigned NOT NULL default '0',
			  `date_modified` int(10) unsigned NOT NULL default '0',
			  PRIMARY KEY  (`currency_id`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

		");
		$db->query("
			CREATE TABLE IF NOT EXISTS `xf_credits_transaction` (
			  `transaction_id` bigint(20) unsigned NOT NULL auto_increment,
			  `action_id` varchar(100) NOT NULL,
			  `user_id` int(10) unsigned NOT NULL default '0',
			  `user_action_id` int(10) unsigned NOT NULL default '0',
			  `owner_id` int(10) unsigned NOT NULL default '0',
			  `multiplier` int(10) unsigned NOT NULL default '0',
			  `transaction_date` int(10) NOT NULL,
			  `amount` double NOT NULL default '0',
			  `negate` tinyint(1) unsigned NOT NULL default '0',
			  `message` text NOT NULL,
			  `transaction_state` varchar(30) NOT NULL,
			  `extra_data` mediumblob NOT NULL COMMENT 'Serialized. Stores any extra data relevant to the transaction',
			  PRIMARY KEY  (`transaction_id`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;
		");
		
		$db->query("
			INSERT IGNORE INTO `xf_credits_currency` (`currency_id`, `title`, `code`, `symbol_left`, `symbol_right`, `decimal_place`, `value`, `status`, `date_modified`) VALUES
			(1, 'United States Dollar', 'USD', '$', '', 2, 1.00000000, 1, 1357576737);
		");
		$db->query("
			INSERT IGNORE INTO `xf_credits_action` (`action_id`, `user_groups`, `forums`, `display_order`, `amount`, `sub_amount`, `multiplier`, `sub_multiplier`, `active`, `alert`, `times`, `max_time`, `apply_max`, `target`, `addon_id`, `template`, `global`) VALUES
			('login', '', '', 1, 6, 0, 0, 0, 1, 1, 1, 0, 0, 'user', 'Brivium_Credits', '0', 1),
			('createNewThread', '', '', 200, 20, 0, 0.01, 0, 1, 1, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion_create', 1),
			('newPost', '', '', 300, 10, 0, 0.01, 0, 1, 1, 20, 0, 2, 'user', 'Brivium_Credits', 'discussion_create', 1),
			('uploadAttachment', '', '', 310, 5, 0, 0, 0, 1, 0, 20, 0, 0, 'user', 'Brivium_Credits', 'discussion_revert', 1),
			('transfer', '', '', 3, 5, 0, 0.5, 0, 1, 1, 0, 0, 0, 'user', 'Brivium_Credits', 'transfer', 1),
			('threadDeleted', '', '', 210, -20, 0, -0.01, 0, 1, 1, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion_create', 1),
			('updateFullProfile', '', '', 120, 20, -20, 0, 0, 1, 1, 0, 0, 0, 'user', 'Brivium_Credits', 'user', 1),
			('receivePostLike', '', '', 320, 6, 0, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion_revert', 1),
			('likePost', '', '', 321, 1, -1, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion_revert', 1),
			('postDeleted', '', '', 301, -10, 0, -0.01, 0, 1, 1, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion_create', 1),
			('birthday', '', '', 60, 40, 0, 1, 0, 1, 1, 0, 31536000, 1, 'user', 'Brivium_Credits', 'birthday', 1),
			('threadGetReply', '', '', 240, 2, 0, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion', 1),
			('createNewPoll', '', '', 250, 10, 0, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion', 1),
			('votePoll', '', '', 251, 2, 0, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion', 1),
			('reportPost', '', '', 320, 2, 0, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion', 1),
			('postReported', '', '', 330, 5, 0, 0, 0, 1, 1, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion', 1),
			('threadViewed', '', '', 240, 1, 0, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion', 1),
			('readThread', '', '', 241, 1, 0, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion', 1),
			('downloadAttachment', '', '', 311, 1, 0, 0, 0, 1, 1, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion', 1),
			('attachmentDownloaded', '', '', 312, 1, 0, 0, 0, 1, 1, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion', 1),
			('threadSticky', '', '', 260, 5, -5, 0, 0, 1, 1, 0, 0, 0, 'user', 'Brivium_Credits', 'discussion_revert', 1),
			('getFollower', '', '', 141, 10, -10, 0, 0, 1, 1, 0, 0, 0, 'user', 'Brivium_Credits', 'user', 1),
			('updateStatus', '', '', 140, 4, 0, 0, 0, 1, 0, 1, 0, 0, 'user', 'Brivium_Credits', 'user', 1),
			('profilePost', '', '', 150, 2, 0, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'user', 1),
			('likeProfilePost', '', '', 151, 0, -2, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'user', 1),
			('receiveProfilePostLike', '', '', 152, 2, -2, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'user', 1),
			('createConversation', '', '', 160, 3, -3, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'user', 1),
			('uploadAvatar', '', '', 121, 5, -5, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'user', 1),
			('follow', '', '', 140, 2, -2, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'user', 1),
			('pollGetVote', '', '', 252, 2, 0, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'user', 1),
			('getProfilePost', '', '', 150, 2, 0, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'user', 1),
			('interest', '', '', 90, 0, 0, 0.04, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', 'interest', 1),
			('importVbb', '', '', 70, 0, 0, 0, 0, 1, 0, 0, 0, 0, 'user', 'Brivium_Credits', '0', 1),
			('registration', '', '', 20, 10, 0, 0, 0, 1, 1, 1, 0, 1, 'user', 'Brivium_Credits', 'user', 1);

		");
		
		$db->query("REPLACE INTO `xf_content_type` (content_type, addon_id, fields) VALUES ('credit', 'Brivium_Credits', '')");
		$db->query("REPLACE INTO `xf_content_type_field` (content_type, field_name, field_value) VALUES ('credit', 'alert_handler_class', 'Brivium_Credits_AlertHandler_Credit')");
		XenForo_Model::create('XenForo_Model_ContentType')->rebuildContentTypeCache();
		if (!self::checkIfExist('xf_user', 'credits')) {
			self::addColumn('xf_user', 'credits', " DOUBLE NOT NULL DEFAULT  '0'");
		}
		if (!self::checkIfExist('xf_user', 'currency_id')) {
			self::addColumn('xf_user', 'currency_id', " int(11) unsigned NOT NULL default '0'");
		}
		
		return true;
	}
	
	
	/**
	 * So sad. Delete all the data used by this addon
	 */
	public static function uninstall()
	{
		$db = XenForo_Application::getDb();
		if (!self::checkIfExist('xf_user', 'credits')) {
			$db->query("ALTER TABLE `xf_user` DROP `credits`");
		}
		
		if (!self::checkIfExist('xf_user', 'currency_id')) {
			$db->query("ALTER TABLE `xf_user` DROP `currency_id`");
		}
		$db->query("DELETE FROM `xf_user_alert` WHERE `xf_user_alert`.`content_type` = 'credit';");
		$db->query("DROP TABLE `xf_credits_action`");
		$db->query("DROP TABLE `xf_credits_transaction`");
		$db->query("DROP TABLE `xf_credits_currency`");
		$db->query("DELETE FROM `xf_content_type` WHERE `xf_content_type`.`content_type` = 2 AND `xf_content_type`.`addon_id` = 'Brivium_Credits' LIMIT 1;");
		
		$db->query("DELETE FROM `xf_content_type_field` WHERE `xf_content_type_field`.`content_type` = 'credit' AND `xf_content_type_field`.`content_type` = 'alert_handler_class'   AND `xf_content_type_field`.`content_type` = 'Brivium_Credits_AlertHandler_Credit'  LIMIT 1;");
		return true;
	}
}

?>