<?php
class Brivium_Credits_DataWriter_DiscussionMessage_Post extends XFCP_Brivium_Credits_DataWriter_DiscussionMessage_Post
{

	protected function _messagePostSave()
	{
		
		if ($this->isInsert() && !$this->isDiscussionFirstMessage())
		{
			$creditModel = $this->_getCreditModel();
			$thread = $this->_getThreadModel()->getThreadById($this->get('thread_id'));
			$post = $this->getMergedData();
			$wordCount = $creditModel->calculateWordAmount(strtolower($post['message']));
			$dataCredit = array(
				'node_id'		=>	$thread['node_id'],
				'multiplier'	=>	$wordCount,
				'extraData' 	=>	array('post_id'=>$this->get('post_id'))
			);
			$errorString = '';
			$newTran = $creditModel->updateUserCredit('newPost',$post['user_id'],$dataCredit,$errorString);
			if($thread['user_id']!=$this->get('user_id')){
				$dataCredit = array(
					'user_action_id' 	=>	$post['user_id'],
					'node_id'=>		$thread['node_id'],
					'extraData' 	=>	array('post_id'=>$this->get('post_id'))
				);
				$creditModel->updateUserCredit('threadGetReply',$thread['user_id'],$dataCredit);
			}
		}
		
		$uploadedNew = false;
		$newAttachCount = 0;
		if ($this->isInsert() && $this->get('attach_count')){
			$uploadedNew = true;
			$newAttachCount = $this->get('attach_count');
		}else if($this->isUpdate() && ($this->get('attach_count') > $this->getExisting('attach_count'))){
			$uploadedNew = true;
			$newAttachCount = $this->get('attach_count') - $this->getExisting('attach_count') ;
		}
		if($uploadedNew && $newAttachCount){
			$creditModel = $this->_getCreditModel();
			
			$thread = $this->_getThreadModel()->getThreadById($this->get('thread_id'));
			$dataCredit = array(
				'node_id'		=>	$thread['node_id'],
				'multi_amount' 	=> 	$newAttachCount,
				'extraData' 	=>	array('post_id'=>$this->get('post_id'))
			);
			$newTran = $creditModel->updateUserCredit('uploadAttachment',XenForo_Visitor::getUserId(),$dataCredit);
		}
		
		return parent::_messagePostSave();
	}


	protected function _messagePostDelete()
	{
		if (!$this->isDiscussionFirstMessage())
		{
			$post = $this->getMergedExistingData();
			$creditModel = $this->_getCreditModel();
			$thread = $this->_getThreadModel()->getThreadById($this->get('thread_id'));
			$wordCount = $creditModel->calculateWordAmount(strtolower($post['message']));
			$dataCredit = array(
				'node_id'		=>	$thread['node_id'],
				'multiplier'	=>	$wordCount,
				'extraData' 	=>	array('thread_id'=>$this->get('thread_id'))
			);
			$newTran = $creditModel->updateUserCredit('postDeleted',$this->get('user_id'),$dataCredit);
		}
		return parent::_messagePostDelete();
	}
	
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
	
	
}