<?php

class Brivium_Credits_AlertHandler_Credit extends XenForo_AlertHandler_Abstract
{
	/**
	 * @var XenForo_Model_Post
	 */
	protected $_postModel = null;
	/**
	 * Fetches the content required by alerts.
	 *
	 * @param array $contentIds
	 * @param XenForo_Model_Alert $model Alert model invoking this
	 * @param integer $userId User ID the alerts are for
	 * @param array $viewingUser Information about the viewing user (keys: user_id, permission_combination_id, permissions)
	 *
	 * @return array
	 */
	public function getContentByIds(array $contentIds, $model, $userId, array $viewingUser)
	{
		/* @var $transactionModel Brivium_Credits_Model_Transaction */
		$transactionModel = $model->getModelFromCache('Brivium_Credits_Model_Transaction');
		$fetchOptions = array(
			'join' =>  Brivium_Credits_Model_Transaction::FETCH_TRANSACTION_FULL
		);
		$transactions = $transactionModel->getTransactions(array('transaction_id' => $contentIds),$fetchOptions);
		return $transactions ;
	}
	protected function _prepareAlertBeforeAction(array $item, $content, array $viewingUser)
	{
		if($item['content_type']=='credit'){
			if ($item['extra_data'])
			{
				$item['extra'] = unserialize($item['extra_data']);
				if(isset($item['extra']['post_id'])){
					$postModel = $this->_getPostModel();
					$posts = $postModel->getPostsByIds(array($item['extra']['post_id']), array(
						'join' => XenForo_Model_Post::FETCH_THREAD | XenForo_Model_Post::FETCH_FORUM,
						'permissionCombinationId' => $viewingUser['permission_combination_id']
					));
					$posts = $postModel->unserializePermissionsInList($posts, 'node_permission_cache');
					$item['extra']['post'] = reset($posts);
				}else if(isset($item['extra']['thread_id'])){
					
				}
			}
			if(isset($item['extra']['reverted'])&&$item['extra']['reverted']){
				$item['reverted'] = true;
				if(!empty($item['action']))$item['actionTitle'] = new XenForo_Phrase('BRC_action_'.$item['action'].'_reverted');
			}else{
				$item['reverted'] = false;
				if(!empty($item['action']))$item['actionTitle'] = new XenForo_Phrase('BRC_action_'.$item['action']);
			}
		}
		//pr($item);
		unset($item['extra_data']);
		return $item;
	}
	protected function _getDefaultTemplateTitle($contentType, $action) {
		return 'BRC_alert_credit_' . $action;
	}
	
	/**
	 * @return XenForo_Model_Post
	 */
	protected function _getPostModel()
	{
		if (!$this->_postModel)
		{
			$this->_postModel = XenForo_Model::create('XenForo_Model_Post');
		}

		return $this->_postModel;
	}
}