<?php
class Brivium_Credits_Model_Credit extends XenForo_Model
{
	/**
	 * update user credit
	 *
	 * @param integer $userId
	 * @param string $actionId
	 * @param array $extra 
	 */
	protected $_otherField = null;
	public function updateUserCredit($actionId,$userId, array $extra = array(),&$errorString = ''){
		
		$actionModel = $this->_getActionModel();
		// get action information
		$action = XenForo_Application::get('brcActions')->$actionId;
		
		// check action is actived
		if(!$action['active'])
		{
			$errorString = new XenForo_Phrase('BRC_this_action_is_not_active_yet');
			return false;
		}
		$now = XenForo_Application::$time;
		$defaultData = array(
			'owner_id' 			=>	0,
			'user_action_id' 	=>	0,
			'transaction_date' 	=>	$now,
			'amount' 			=>	0,
			'negate' 			=>	0,
			'multiplier' 		=>	0,
			'multi_amount' 		=>	0,
			'message' 			=>	'',
			'transaction_state' =>	'',
			'node_id' 			=>	0,
			'times' 			=>	0,
			'apply_max' 		=>	0,
			'max_time' 			=>	0,
			'user' 				=>	array(),
			'ignore_include' 	=>	false,
			'ignore_maximum' 	=>	false,
			'reverted' 			=>	false,
			'extraData' 		=>	array()
		);
		
		$data = array_merge($defaultData, $extra);
		$userActionId 		= $data['user_action_id'];						// user is associated with this action of $user ( default System = 0 )  (int)  
		$ownerId 			= $data['owner_id'];							// not support right now
		$transactionDate 	= $data['transaction_date'];					//  date of transaction (int)
		$amount 			= $data['amount'];								// set amount override action's amount ( if = 0 , amount = action.amount ) (double)
		$negate 			= $data['negate'];								// not support right now
		$message 			= $data['message'];								// comment for this transaction (string)
		$multiplier 		= $data['multiplier'];							// number will calculate with action's multiplier   ( amount = amount + action.multiplier * multiplier )  (int)
		$multiAmount 		= $data['multi_amount'];   						// multipliter Amount  (  amount  = amount x multiAmount )  (int)
		$transactionState 	= $data['transaction_state'];					// Set state for transaction  (string)
		$nodeId 			= $data['node_id'];								// data forum id  (int)
		$times 				= $data['times']?$data['times']:$action['times']; 			// Maximum times per day  (int)
		$applyMax 			= $data['apply_max']?$data['apply_max']:$action['apply_max'];  // Maximum times After this event has occured.  (int)
		$maxTime 			= $data['max_time']?$data['max_time']:$action['max_time'];   // Timespan in seconds that the above maximum is enforced. (int)
		$ignoreInclude 		= $data['ignore_include'];						// ignored check include (forum and user group). (boolen)
		$ignoreMaximum 		= $data['ignore_maximum'];						// ignored check maximum perday and maximum times trigger action.  (boolen)
		$reverted 			= $data['reverted'];							// is reveted action.  (boolen)
		$extraData 			= $data['extraData'];							// entra data for transactiona and alert  (array)
		$user 				= $data['user'];								// user trigger this action.   (array)
		$extraData['action'] = $actionId;
		$extraData['reverted'] = $reverted;
		$extraData['ignoreInclude'] = $ignoreInclude;
		$userModel = $this->getModelFromCache('XenForo_Model_User');
		
		if(is_array($user) && !empty($user['user_id'])){
			$userId = $userId?$userId:$user['user_id'];
		}else if($userId){
			$user = $userModel->getFullUserById($userId);
		}else{
			$errorString = new XenForo_Phrase('requested_user_not_found');
			return false;
		}
		if (!$user || !is_array($user) || empty($user['user_id']))
		{
			$errorString = new XenForo_Phrase('do_not_have_permission');
			return false;
		}
		
		$action = $actionModel->prepareAction($action);
		if(!$ignoreInclude)
			if(!$this->requireInclude($action,$user,$nodeId)){
				$errorString = new XenForo_Phrase('do_not_have_permission');
				return false;
			}
		if($userActionId){
			$userAction = $userModel->getUserById($userActionId);
		}else{
			$userAction = $user;
		}
		
		if($amount==0){
			$amount = $reverted?$action['sub_amount']:$action['amount'];
		}
		if(!$amount){
			$errorString = new XenForo_Phrase('BRC_not_valid_amount');
			return false;
		}
		
		if($multiAmount && $multiAmount != 0){
			$amount *= $multiAmount;
		}
		if($multiplier && $multiplier > 0 && $action['multiplier']){
			$amount = $amount + $action['multiplier'] * $multiplier;
		}
		
		
		if(!$reverted || !$ignoreMaximum){
			if($applyMax > 0){
				$startTime = 0;
				if($maxTime > 0){
					$startTime = $now - $maxTime;
					$maxTimes = $this->countActionOfUser($actionId,$userId,$startTime);
					if($maxTimes >= $applyMax){
						$errorString = new XenForo_Phrase('BRC_you_can_get_reward_x_times_per_day_for_y', array('count' => $applyMax,'action'=>$action['title']));
						return false;
					}
				}
			}
			$dayStartTimestamps = XenForo_Locale::getDayStartTimestamps();
			if($times > 0 && $times <= $this->countActionOfUser($actionId,$userId,$dayStartTimestamps['today'])){
				$errorString = new XenForo_Phrase('BRC_you_can_get_reward_x_times_per_day_for_y',array('time'=>$times,'action'=>$action['title']));
				return false;
			}
		}
		$extraData['amount'] = $amount;
		$extraData['multiAmount'] = $multiAmount;
		$alert = false;
		if(XenForo_Model_Alert::userReceivesAlert($user, 'credits', $actionId) && $action['alert']){
			$alert = true;
		}
		$transactionId = $this->addUserTransactionSimple($actionId, $userId, $userAction, $ownerId, $transactionDate, $amount, $multiplier, $negate, $message, $transactionState, $extraData,$alert);
		//$transactionId = $this->addUserTransactionSimple($dataTransaction,$alert);
		return $transactionId;
	}
	
	
	/**
	 * Add user Transaction Simple with delay option
	 *
	 * @param array $data
	 */
	public function addUserTransactionSimple($actionId, $userId, $userAction, $ownerId, $transactionDate, $amount, $multiplier, $negate, $message, $transactionState, $extraData,$alert)
	{
		//prd($data);
		$db = $this->_getDb();
		$db->query('
			INSERT INTO xf_credits_transaction
				(action_id,user_id,user_action_id,owner_id,transaction_date,amount,multiplier,negate,message,transaction_state,extra_data)
			VALUES
				(?,?,?,?,?,?,?,?,?,?,?)
		',array($actionId, $userId, $userAction['user_id'], $ownerId, $transactionDate, $amount, $multiplier, $negate, $message, $transactionState, serialize($extraData)));
		$transactionId = $db->lastInsertId();
		if($transactionId){
			if($alert){
				$this->createAlert($userId, $userAction['user_id'], $userAction['username'],$transactionId,$actionId,$extraData);
			}
			$this->updateUserCredits($amount,$userId);
		}
		return $transactionId;
	}
	public function updateUserCredits($amount,$userId)
	{
		$otherField = $this->_getOtherField();
		$this->_getDb()->query('
			UPDATE ' . (XenForo_Application::get('options')->BRC_enableUpdateLowPriority ? 'LOW_PRIORITY' : '') . ' xf_user SET
				credits = credits + ?
				'.$otherField.'
			WHERE user_id = ?
		', array($amount, $userId));
		
		return true;
	}
	
	
	
	protected function _getOtherField()
	{
		$otherField = '';
		if(is_null($this->_otherField)){
			$options = XenForo_Application::get('options');
			$fields = preg_split('/\s+/', trim($options->BRC_field));
			if(!empty($fields)){
				foreach($fields AS $field){
					if($this->_checkIfExist('xf_user', $field)){
						$otherField = ", {$field} = credits";
					}
				}
			}
			$this->_otherField = $otherField;
		}else{
			$otherField = $this->_otherField;
		}
		return $otherField;
	}
	/**
	 * alert member
	 *
	 */
	
	public function createAlert($alertUserId, $userId, $username, $transactionId, $actionId, array $extraData = null)
	{
		
		XenForo_Model_Alert::alert(
			$alertUserId,
			$userId,
			$username,
			'credit',
			$transactionId,
			$actionId,
			$extraData
		);
	}
	
	/**
	 * import credits from other field of `xf_user`
	 *
	 */
	public function importCredits($field,$merge = true)
	{
		if (!$this->checkIfExist('xf_user', $field)) {
			return false;
		}
		$merger = '';
		if($merge){
			$merger = ' + credits';
		}
		$this->_getDb()->query('
			UPDATE xf_user SET
				credits = '.$field.' '.$merger.'
		');
	}
	public function checkIfExist($table, $field)
	{
		$db = XenForo_Application::get('db');
		if ($db->fetchRow('SHOW columns FROM `' . $table . '` WHERE Field = ?', $field)) {
			return true;
		}
		else {
			return false;
		}
	}
	/**
	 * Set all trophy point to 0
	 *
	 */
	public function resetTrophyPoints()
	{
		$this->_getDb()->query('
			UPDATE xf_user SET trophy_points = 0
		');
	}
	
	/**
	 * Set all credits to amount
	 *
	 *	@param double $amount
	 */
	public function resetCredit($amount = 0)
	{
		$this->_getDb()->query('
			UPDATE xf_user SET credits = ?
		',$amount);
	}
	
	/**
	 * Count number action that user trigger in preiod times
	 *
	 *	@param string $actionId
	 *	@param int $userId
	 *	@param int $startTime   from start time to now
	 *	@param int $userActionId
	 */
	public function countActionOfUser($actionId,$userId,$startTime = 0,$userActionId = 0){
		$transactionModel = $this->_getTransactionModel();
		$conditions = array(
			'action_id'	=>	$actionId,
			'user_id'	=>	$userId,
		);
		
		if($userActionId)$conditions['user_action_id'] = $userActionId;
		if($startTime)$conditions['start'] = $startTime;
		return $transactionModel->countTransactions($conditions);
	}
	
	/**
	 * Check if user in group that allowed to trigger action or Forum is in Included Forum
	 *
	 *	@param array|string $action
	 *	@param array|int $user
	 *	@param int $nodeId 
	 */
	public function requireInclude($action,$user = array(),$nodeId = 0){
		if(!$user){
			$user = XenForo_Visitor::getInstance()->toArray();
		}
		if(!is_array($action)){
			$actionModel = $this->_getActionModel();
			// get action information
			$action = XenForo_Application::get('brcActions')->$action;
			$action = $actionModel->prepareAction($action);
		}
		$check = true;
		$includeGroups = $action['user_groups'];
		$includeForums = $action['forums'];
		if(!empty($includeGroups) && $includeGroups!=array(0=>0)){
			$check = false;
			$inGroups = array();
			if(isset($user['user_group_id']))
				$inGroups = $user['user_group_id'];

			if (!empty($user['secondary_group_ids']))
			{
				$inGroups .= ','.$user['secondary_group_ids'];
			}

			$groupCheck = explode(',',$inGroups);

			unset($inGroups);

			foreach ($groupCheck AS $groupId)
			{
				if (in_array($groupId, $includeGroups))
				{
					$check = true;
					break;
				}
			}
		}
		
		if(!empty($includeForums)  && $includeForums!=array(0=>0) && $nodeId){
			$check = false;
			if (in_array($nodeId, $includeForums)){
				$check = true;
			}
		}
		return $check;
	}
	
	
	public function processTax($amount,$action){
		if(!is_array($action)){
			$actionModel = $this->_getActionModel();
			$action = $actionModel->getActionById($actionId);
		}
		$userTax = 0;
		$userActionTax = 0;
		$bothTax = 0;
		
		$taxed = ($amount-$action['amount']) * $action['multiplier'] + $action['amount'];
		if($action['target']=='user'){
			$userTax = $taxed;
		}else if($action['target']=='user_action'){
			$userActionTax = $taxed;
		}else if($action['target']=='both'){
			$bothTax = $taxed/2;
		}
		
		return array(
			$userTax,$userActionTax,$bothTax
		);
		return $taxedAmount;
	}
	
	
	public function calculateWordAmount($string){
	
		if(XenForo_Application::get("options")->BRC_excludeBlockBbcode){
			$string = preg_replace('#\[(quote|php|html|code)[^\]]*\].*\[/\\1\]#siU', ' ', $string);
		}
		$string = preg_replace('#\[(attach|media|img)[^\]]*\].*\[/\\1\]#siU', ' [\\1] ', $string);
		while ($string != ($newString = preg_replace('#\[([a-z0-9]+)(=[^\]]*)?\](.*)\[/\1\]#siU', '\3', $string)))
		{
			$string = $newString;
		}
		return $this->countWords($string);
	}
	
	public function countWords($string) 
	{
		$count = 0;
		if(XenForo_Application::get("options")->BRC_creditSizeWord){
			$count = count(explode(" ", $string));
		}else{
			$count = utf8_strlen($string);
		}
		return $count;
	}
	
	public function stripBbCode($string) 
	{
		if ($stripQuote)
		{
			$string = preg_replace('#\[(quote)[^\]]*\].*\[/\\1\]#siU', ' ', $string);
		}

		// replaces unviewable tags with a text representation
		$string = preg_replace('#\[(attach|media|img)[^\]]*\].*\[/\\1\]#siU', '[\\1]', $string);

		while ($string != ($newString = preg_replace('#\[([a-z0-9]+)(=[^\]]*)?\](.*)\[/\1\]#siU', '\3', $string)))
		{
			$string = $newString;
		}

		$string = str_replace('[*]', '', $string);
	}
	
	public function totalCredits(){
		return $this->_getDb()->fetchOne('
			SELECT SUM(credits)
			FROM xf_user
		');
	}
	
	public function footer(){
		return '
			<div id="BRC_CopyrightNotice" class="footerLegal" style="clear:both">
			<div class="pageContent">
			<span class="muted"><a href="http://brivium.com/link-forums/information.109/" title="Credits System" class="concealed" >Credits</a> by Brivium ™ &copy; 2012-2013  <a href="http://brivium.com/" class="concealed" title="Brivium Limited">Brivium Limited</a>.</span>
			</div>
			</div>';
	}
	
	protected function _checkIfExist($table, $field)
	{
		$db = XenForo_Application::get('db');
		if ($db->fetchRow('SHOW columns FROM `' . $table . '` WHERE Field = ?', $field)) {
			return true;
		}
		else {
			return false;
		}
	}
	/**
	 * Gets the user model.
	 *
	 * @return XenForo_Model_User
	 */
	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Action
	 */
	protected function _getActionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Action');
	}
	/**
	 * Gets the transaction model.
	 *
	 * @return Brivium_Credits_Model_Transaction
	 */
	protected function _getTransactionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Transaction');
	}
	
}