<?php

class XenGallery_ControllerPublic_FindNew extends XFCP_XenGallery_ControllerPublic_FindNew
{
	/**
	 * Finds new/unread media.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionMedia()
	{
		$this->_routeMatch->setSections('xengallery');
		
		$searchId = $this->_input->filterSingle('search_id', XenForo_Input::UINT);
		if (!$searchId)
		{
			return $this->findNewMedia();
		}
		
		$searchModel = $this->_getSearchModel();

		$search = $searchModel->getSearchById($searchId);
		if (!$search
			|| $search['user_id'] != XenForo_Visitor::getUserId()
		)
		{
			return $this->findNewMedia();
		}		
		
		$page = max(1, $this->_input->filterSingle('page', XenForo_Input::UINT));
		$perPage = XenForo_Application::get('options')->xengalleryMediaMaxPerPageHome;

		$pageResultIds = $searchModel->sliceSearchResultsToPage($search, $page, $perPage);
		$results = $searchModel->getSearchResultsForDisplay($pageResultIds);
		if (!$results)
		{
			return $this->getNoMediaResponse();
		}

		$resultStartOffset = ($page - 1) * $perPage + 1;
		$resultEndOffset = ($page - 1) * $perPage + count($results['results']);
		
		$mediaModel = $this->_getMediaModel();

		$media = array();
		foreach ($results['results'] AS $result)
		{
			$media[$result[XenForo_Model_Search::CONTENT_ID]] = $result['content'];
		}
		
		$viewParams = array(
			'search' => $search,		
			'findNewPage' => 'media',
			'media' => $media,
			'threadStartOffset' => $resultStartOffset,
			'threadEndOffset' => $resultEndOffset,
			
			'page' => $page,
			'perPage' => $perPage,
			'totalMedia' => $search['result_count'],
			'nextPage' => ($resultEndOffset < $search['result_count'] ? ($page + 1) : 0),						
		);
		
		return $this->getFindNewWrapper(
			$this->responseView('XenGallery_ViewPublic_FindNew_Media', 'xengallery_find_new_media', $viewParams),
			'media'
		);
	}
	
	/**
	 * For backwards compatibility
	 */
	public function actionThreads()
	{
		$parent = parent::actionThreads();
		
		if ($parent instanceof XenForo_ControllerResponse_View)
		{
			if (!empty($parent->params['threads']))
			{
				return $this->getFindNewWrapper($parent, 'threads');
			}
			else
			{
				return $this->getNoResultsResponse();
			}
		}
		
		return $parent;
	}
	
	public function findNewMedia()
	{
		$mediaModel = $this->_getMediaModel();
		$searchModel = $this->_getSearchModel();
		
		$userId = XenForo_Visitor::getUserId();
		
		$limitOptions = array(
			'limit' => XenForo_Application::get('options')->maximumSearchResults
		);
		
		if ($userId)
		{
			$mediaIds = $mediaModel->getUnviewedMediaIds($userId, $limitOptions);
		}				
		else
		{
			$fetchOptions = $limitOptions + array(
				'order' => 'media_date',
				'orderDirection' => 'desc'
			);

			$mediaIds = array_keys($mediaModel->getMedia(array(
				'media_date' => array('>', XenForo_Application::$time - 86400 * 7),
				'deleted' => false,
				'moderated' => false
			), $fetchOptions));
		}
		
		if ($mediaIds)
		{
			$media = $mediaModel->getMediaByIds(
				$mediaIds,
				array(
					'join' =>
						XenGallery_Model_Media::FETCH_USER |
						XenGallery_Model_Media::FETCH_ATTACHMENT
				)
			);
			$media = $mediaModel->prepareMedia($media);			
		}		

		$results = array();
		foreach ($mediaIds AS $mediaId)
		{
			if (isset($media[$mediaId]))
			{
				$results[] = array(
					XenForo_Model_Search::CONTENT_TYPE => 'xengallery_media',
					XenForo_Model_Search::CONTENT_ID => $mediaId
				);
			}
		}

		$search = $searchModel->insertSearch($results, 'xengallery_media', '', array(), 'date', false);

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildPublicLink('find-new/media', $search)
		);		
	}
	
	public function getNoMediaResponse()
	{
		$this->_routeMatch->setSections('xengallery');
		
		return $this->getFindNewWrapper($this->responseView('XenGallery_ViewPublic_FindNew_MediaNoResults', 'xengallery_find_new_no_response', array('link' => XenForo_Link::buildPublicLink(XenForo_Application::get('options')->xengalleryRoutePrefix))), 'media');
	}
	
	public function getNoResultsResponse()
	{
		$days = $this->_input->filterSingle('days', XenForo_Input::UINT);
		$recent = $this->_input->filterSingle('recent', XenForo_Input::UINT);
	
		$this->_routeMatch->setSections('forums');
	
		return $this->getFindNewWrapper($this->responseView('XenForo_ViewPublic_FindNew_ThreadsNone', 'xengallery_find_new_threads_none', array(
			'days' => $days,
			'recent' => $recent
		)), 'threads');
	}
	
	public function getFindNewWrapper(XenForo_ControllerResponse_View $subView, $selectedTab)
	{
		if (method_exists('XenForo_ControllerPublic_FindNew', 'getFindNewWrapper'))
		{
			return parent::getFindNewWrapper($subView, $selectedTab);
		}
		else
		{
			$tabs = $this->_getWrapperTabs();
			
			$view = $this->responseView('XenForo_ViewPublic_FindNew_Wrapper', 'xengallery_find_new_wrapper', array(
				'tabs' => $tabs,
				'showTabs' => count($tabs) > 1,
				'selectedTab' => $selectedTab
			));
			$view->subView = $subView;
			
			return $view;			
		}
	}
	
	protected function _getWrapperTabs()
	{
		if (method_exists('XenForo_ControllerPublic_FindNew', '_getWrapperTabs'))
		{
			$parent = parent::_getWrapperTabs();
			
			$parent['media'] = array(
				'href' => XenForo_Link::buildPublicLink('find-new/media'),
				'title' => new XenForo_Phrase('xengallery_new_media')
			);
			
			return $parent;
		}
		else
		{
			return array(
				'threads' => array(
					'href' => XenForo_Link::buildPublicLink('find-new/threads'),
					'title' => new XenForo_Phrase('new_threads')
				),
				'media' => array(
					'href' => XenForo_Link::buildPublicLink('find-new/media'),
					'title' => new XenForo_Phrase('xengallery_new_media')				
				)
			);			
		}
	}	
	
	/**
	 * @return XenGallery_Model_Media
	 */
	protected function _getMediaModel()
	{
		return $this->getModelFromCache('XenGallery_Model_Media');
	}
}
