<?php
function get_currentuserinfo() {
	global $current_user, $XF;

	if ( defined('XMLRPC_REQUEST') && XMLRPC_REQUEST )
		return false;

	if ( ! empty($current_user) )
		return;
	
	$visitor = $XF->visitor;

	if ( $visitor->get('user_id') == 0 ) { //no XenForo user logged in
	 	wp_set_current_user(0);
		return false;
	}
	
	wp_set_current_user($visitor->get('user_id'));
}



function get_userdata( $user_id ) {
	global $wpdb;

	if ( ! is_numeric( $user_id ) )
		return false;

	$user_id = absint( $user_id );
	if ( ! $user_id )
		return false;

	$user = wp_cache_get( $user_id, 'users' ); //check to see if the cache object already has the user

	if ( $user )
	{
		return $user; //it was in the cache
	}
	
	$user = new StdClass;
	global $XF;
	XF_User_Data::fillUserData($XF->visitor, $user, $user_id);
	
	update_user_caches($user);
	
	return $user;
}

//Display an error when trying to view the 'Users' tab on the WP Admin page
function cache_users( $users ) {
	wp_die("Please handle user changes through Xenforo, not Wordpress.");
}

function xf_login_redirect($url)
{
	global $XF;
	$login = $XF->createLink('login');
	$protocol = (!empty($_SERVER['HTTPS'])) ? "https://" : "http://";
	if(strpos($login, '?') === false)
	{
		return $login . '?redirect=' . $protocol . $_SERVER['SERVER_NAME'] .  $_SERVER['REQUEST_URI'];
	}
	else
	{
		return $login . '&redirect=' . $protocol . $_SERVER['SERVER_NAME'] .  $_SERVER['REQUEST_URI'];
	}
	return $XF->createLink('login');
}

function xf_logout_redirect($url)
{
	global $XF;
	
	return $XF->createLink('logout');
}

function xf_register_redirect($url)
{
	global $XF;
	
	return $XF->createLink('register');
}

function xf_profile_redirect($url)
{
	global $XF;
	
	return $XF->createLink('account');
}

function xf_dashboard_redirect($url, $user_id, $path, $scheme)
{
	global $XF;
	
	if($path == 'profile.php')
	{
		return $XF->createLink('members/' . $user_id . '/');
	}
	
	return $url;
}

function xf_admin_url($url, $path, $blog_id)
{
	global $XF;
	
	if($path == 'profile.php')
	{
		return $XF->createLink('members/' . strtolower($XF->visitor->get('username')) . '.' . $XF->visitor->get('user_id') . '/');
	}
	
	return $url;
}

function xf_site_admins($option)
{
	require 'multisite-config.php';
	return $site_admins;
}

//filters the output from the normal wp_redirect function, attempting to catch redirects from wp-admin to the login page
function xf_wp_redirect($url)
{
	return $url;
}

function xf_redirect_login_page()
{
	global $XF;
	
	//we should not be able to visit this page ever, but just in case we do let's fill in an HTML redirect
	echo "<meta HTTP-EQUIV='REFRESH' content='0; url=" . $XF->createLink('login') . "'>";
	echo "<title>Login page moved</title>";
	echo "<head>";
	echo "<body><h2 style='text-align: center'>Please visit our <a href='" . $XF->createLink('login') . "'>login page</a>.</body>";
	echo "</html>";
	die();
}

add_action('login_head', 'xf_redirect_login_page');
add_filter('wp_redirect', 'xf_wp_redirect');
add_filter('login_url', 'xf_login_redirect');
add_filter('logout_url', 'xf_logout_redirect');
add_filter('register_url', 'xf_register_redirect');
add_filter('edit_profile_url', 'xf_profile_redirect');
add_filter('user_dashboard_url', 'xf_dashboard_redirect', 10, 4);
add_filter('admin_url', 'xf_admin_url', 10, 4);
add_filter('pre_site_option_site_admins', 'xf_site_admins');

//This does the redirects needed if we're doing a register or forgot password action
global $XF;

if(isset($_REQUEST['action']))
{
	if($_REQUEST['action'] == 'register')
	{
		header( 'location: ' . $XF->createLink('register'));
		exit;
	}
	if($_REQUEST['action'] == 'lostpassword')
	{
		header( 'location: ' . $XF->createLink('lost-password'));
		exit;
	}
}
?>