<?php
//------------------------------------------------------------------------------------
//status:               CHECKED IN
//------------------------------------------------------------------------------------
/**
 * cls_xfconfig.php
 * @package plugins_shared
 * @version version 1.4.0
 * @copyright EIP Software LLC - eipSoftware_Copyright.php
 */
//------------------------------------------------------------------------------------
/**
 * read the xenforo config file
 */
class eipXFConfig
{
	private static $xfDBConfig;			//store the XF DB config settings
	
	/**
	 * double check to make sure the specified file is readable 
	 * @param string $filename
	 */
	public function __construct($filename)
	{	
		try
        {
			if(is_readable($filename))
			{
				include($filename);	
				self::$xfDBConfig = $config;
			}
			else
			{
				echo("<br />The forum directory file: <br/>" . $filename . "<br/>could not be located.<br /><br />\n\n");
				throw new ExceptionHandler("The Xenforo config file not located");
			}
        }
		catch(ExceptionHandler $e)
        {
            $e->ParseError("The Xenforo config file not located.<br/>");
        }
	}
	/**
	 * return specified value from the xf config file
	 * @param string $value
	 * @param string $subvalue
	 * @return string
	 */
	public function getValue($value,$subvalue)
	{
		if(array_key_exists($value, self::$xfDBConfig) && array_key_exists($subvalue, self::$xfDBConfig[$value]))
		{
			return(self::$xfDBConfig[$value][$subvalue]);
		}
	}
}
?>