<?php
//------------------------------------------------------------------------------------
//status:               CHECKED IN
//------------------------------------------------------------------------------------
/**
 * cls_lastposts.php:    run the query to get the last posts and build an html table
 * @package plugins_lastposts
 * @version version 1.4.0
 * @copyright EIP Software LLC - eipSoftware_Copyright.php
 */
//------------------------------------------------------------------------------------
/**
 * Get Last Posts --> run the queries to get the latest forum posts
 * @return string html formatted
 */
class getLastPosts
{
	public static $userOptions;	//get the user options
	//private $qry;					//PDO or sql object
	private static $arr_Results;	//hold the query results
	private $html_Table;			//hold the html string

	public function __construct()
	{

		self::$userOptions = get_option("eipForumOptions");
		(self::$userOptions["forumDBConn"] == "PDO") ? include_once dirname( __FILE__ ) . '/../../shared/cls/cls_mypdo.php' 
													 : include_once dirname( __FILE__ ) . '/../../shared/cls/cls_runquery.php';
	}

	/**
	 * Get the thread data from the Xenforo database
	 * @return array table data
	 */
	public function getForumData()
	{
		switch (self::$userOptions["forumDBConn"])
		{
			case "SQL" :
			{
				$rq = new eipRunQuery(self::$userOptions);
				//run query to get the listing of private nodes	
				self::$userOptions["excludeNodes"] = self::getPrivateForums($rq->getQueryResults(qry_PrivateNodeList()));
				//run querty to get the last posts
				self::$arr_Results = $rq->getQueryResults(self::getQryString());			
				break;
			}
			case "PDO" :
			{
				$pd = new eipPDO(self::$userOptions);
				self::$userOptions["excludeNodes"] = self::getPrivateForums($pd->getResults(Array('sql'=>qry_PrivateNodeList())));
				self::$arr_Results = $pd->getResults(Array('sql'=>self::getQryString()));
				break;
			}
			default :
			{
				return("Unsupported Data Connection selected, Enter in SQL or PDO");	
			}
		}
		unset($rq);
		unset($pd);
		return($this->BuildTable());
	}
	/**
	 * Determine which query to run
	 * @return string formatted sql query
	 */
	private function getQryString()
	{
		switch (self::$userOptions['forumWidget'])
		{
			case "footer" :
			{
				$sql = qry_LastPost(self::$userOptions);
				break;
			}	
			case "sidebar_table" :
			{
				$sql = qry_LastPost(self::$userOptions);
				break;
			}		
			case "sidebar_list" :
			{
				$sql = qry_LastPostList(self::$userOptions);
				break;
			}	
			default :
			{
				$sql = qry_LastPost(self::$userOptions);		
			}
		}
		return($sql);
	}
	
	/**
	 * Merge the private node list with the excluded node list from user options
	 * @param array $privateNodes
	 * @return string
	 */
	private function getPrivateForums($privateNodes)
	{
		$nodeList = "-1";
		if(is_array($privateNodes))
		{
			foreach($privateNodes as $feRow)
			{
				$nodeList .= "," . $feRow['content_id'];
			}
		}
		if(strlen(self::$userOptions['forumNodeList'])>0)
		{
			$nodeList .= "," . self::$userOptions['forumNodeList'];
		}
		return($nodeList);
	}
	/**
	 * builds the html for the table title
	 * @return string html for table title
	 */
	private function BuildTableTitle()
	{
		// /forums/index.php?find-new/threads
		$html_lnk = new Link(array('href'=>self::$userOptions['forumDomain'].'/index.php?find-new/threads',
									'text'=>self::$userOptions['forumTitle']));
		$str_html = '<span class="eiplastpost">'. $html_lnk->getElement() . '</span>';
		return($str_html);
	}
	/**
	 * Build the table that shows the last posts table
	 * @return string containing html
	 */
	private function BuildTable()
	{
		/*	here is where you can customize the what the table output will look like for your own needs
		 * /cls/cls_footertable.php		table in the footer
		 * /cls/cls_sidebartable.php	table in the sidebar
		 */
		switch (self::$userOptions['forumWidget']) 
		{
			case 'footer':
			{
				$widgetTable = new footerTable(self::$arr_Results);
				$str_html = $this->BuildTableTitle() . $widgetTable->getHtmlTable(self::$userOptions['forumDomain']);
				break;
			}
			case 'sidebar_table':
			{
				$widgetTable = new sidebarTable(self::$arr_Results);
				$str_html = $widgetTable->getHtmlTable(self::$userOptions['forumDomain']);
				break;
			}
			case 'sidebar_list':
			{
				$widgetTable = new sidebarList(self::$arr_Results);
				$str_html = $widgetTable->getHtmlTable(self::$userOptions['forumDomain']);
				break;
			}
			default:
			{
				$str_html = "<br />Table Type specified incorrect<br />";
				break;
			}
		}
		return($str_html); 
	}
}
?>