<?php

class XenGallery_ViewPublic_Media_PreviewVideo extends XenForo_ViewPublic_Base
{
	public function renderJson()
	{
        if (isset($this->_params['mediaTag']))
        {
            $mediaTag = $this->_params['mediaTag'];
            
            $bbCodeParser = new XenForo_BbCode_Parser(XenForo_BbCode_Formatter_Base::create('Base', array('view' => $this)));
            $html = new XenForo_BbCode_TextWrapper($mediaTag, $bbCodeParser);
            
            $this->_params['item']['videoHtml'] = $html;
            
            $this->_templateName = 'xengallery_media_thumb';            
        }
        
        if (!empty($this->_params['throwError']))
        {
            if (!empty($this->_params['notValid']))
            {
                $this->_params = array(
                    'error' => new XenForo_Phrase('xengallery_not_a_valid_media_site')
                );                
            }
            
            if (!empty($this->_params['notAllowed']))
            {
                $this->_params = array(
                    'error' => new XenForo_Phrase('xengallery_use_of_this_media_site_not_allowed')
                );            
            }        
            
            return XenForo_ViewRenderer_Json::jsonEncodeForOutput(array('error' => $this->_params['error']));
        }
	}
}