<?php

class XenGallery_ViewPublic_Media_LikeConfirmed extends XenForo_ViewPublic_Base
{
	public function renderJson()
	{
		$media = $this->_params['media'];

		if (!empty($media['likeUsers']))
		{
			$params = array(
				'message' => $media,
				'likesUrl' => XenForo_Link::buildPublicLink('xenmediagallery', $media)
			);

			$output = $this->_renderer->getDefaultOutputArray(get_class($this), $params, 'likes_summary');
		}
		else
		{
			$output = array('templateHtml' => '', 'js' => '', 'css' => '');
		}

		$output += XenForo_ViewPublic_Helper_Like::getLikeViewParams($this->_params['liked']);

		return XenForo_ViewRenderer_Json::jsonEncodeForOutput($output);
	}
}