<?php

class XenGallery_ViewPublic_Album_LikeConfirmed extends XenForo_ViewPublic_Base
{
	public function renderJson()
	{
		$album = $this->_params['album'];

		if (!empty($album['likeUsers']))
		{
			$params = array(
				'message' => $album,
				'likesUrl' => XenForo_Link::buildPublicLink('media/albums', $album)
			);

			$output = $this->_renderer->getDefaultOutputArray(get_class($this), $params, 'likes_summary');
		}
		else
		{
			$output = array('templateHtml' => '', 'js' => '', 'css' => '');
		}

		$output += XenForo_ViewPublic_Helper_Like::getLikeViewParams($this->_params['liked']);

		return XenForo_ViewRenderer_Json::jsonEncodeForOutput($output);
	}
}