<?php

class XenGallery_ControllerPublic_Forum extends XFCP_XenGallery_ControllerPublic_Forum
{
	public function actionIndex()
	{
		$parent = parent::actionIndex();
		
		$options = XenForo_Application::get('options');
		
		if (!$options->xengalleryForumListRecent || !XenForo_Visitor::getInstance()->hasPermission('xengallery', 'view'))
		{
			return $parent;
		}
		
		$mediaModel = $this->_getMediaModel();
		
		$order = $options->xengalleryRecentMediaOrder;
		
		$categories = $options->xengalleryRecentMediaCategories;
		
		$conditions = array(
			'category_id' => $categories
		);
		
		$fetchOptions = array(
			'join' => XenGallery_Model_Media::FETCH_USER | XenGallery_Model_Media::FETCH_CATEGORY | XenGallery_Model_Media::FETCH_ATTACHMENT,
			'order' => $order,
			'orderDirection' => 'desc',
			'limit' => $options->xengalleryRecentMediaLimit,
		);
		
		$media = $mediaModel->getMedia($conditions, $fetchOptions);
		$media = $this->_getAttachmentModel()->prepareAttachments($media);
		$media = $mediaModel->prepareMedia($media);
		
		if ($order == 'rand')
		{
			$blockPhrase = new XenForo_Phrase('xengallery_random_media');
		}
		else
		{
			$blockPhrase = new XenForo_Phrase('xengallery_new_media');
		}		
		
		$parent->params['media'] = $media;
		$parent->params['blockPhrase'] = $blockPhrase;
		
		return $parent;
	}
	
	protected function _getMediaFetchOptions()
	{
		$mediaFetchOptions = array(
			
		);
		
		return $mediaFetchOptions;
	}	
	
	/**
	 * @return XenGallery_Model_Media
	 */	
	protected function _getMediaModel()
	{
		return $this->getModelFromCache('XenGallery_Model_Media');
	}
	
	/**
	 * @return XenForo_Model_Attachment
	 */
	protected function _getAttachmentModel()
	{
		return $this->getModelFromCache('XenForo_Model_Attachment');
	}	
}
