<?php

class Waindigo_PostAsUser_Listener_TemplateHook extends Waindigo_Listener_TemplateHook
{
	public function run() {
		switch ($this->_hookName)
		{
			case 'thread_create_fields_extra':
				$this->_createFieldsExtra();
				break;
			case 'thread_reply':
				$this->_threadReply();
				break;
		}
		return parent::run();
	}
	
	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		$templateHook = new Waindigo_PostAsUser_Listener_TemplateHook($hookName, $contents, $hookParams, $template);
		$contents = $templateHook->run();
	}
	
	protected function _createFieldsExtra()
	{
		/* @var $userModel XenForo_Model_User */
		$userModel = XenForo_Model::create('XenForo_Model_User');
		
		if ($userModel->canPostAsDifferentUser())
		{
			$viewParams = $this->_fetchViewParams();
			if (Waindigo_Listener_ControllerPreDispatch::isAddOnEnabled('Waindigo_AutoCombo', 'load_class_controller'))
			{
				$viewParams['useAutoCombo'] = true;
			}
			$this->_appendTemplate('waindigo_post_as_user_field_postasuser', $viewParams);
		}
	}

	protected function _threadReply()
	{
		/* @var $userModel XenForo_Model_User */
		$userModel = XenForo_Model::create('XenForo_Model_User');
		
		if ($userModel->canPostAsDifferentUser())
		{
			$viewParams = $this->_fetchViewParams();
			if (Waindigo_Listener_ControllerPreDispatch::isAddOnEnabled('Waindigo_AutoCombo', 'load_class_controller'))
			{
				$viewParams['useAutoCombo'] = true;
			}
			$this->_appendTemplate('waindigo_post_as_user_field_postasuser', $viewParams);
		}
	}
}