<?php

class Waindigo_LastPostAvatar_Extend_Waindigo_SocialGroups_Model_SocialForum extends XFCP_Waindigo_LastPostAvatar_Extend_Waindigo_SocialGroups_Model_SocialForum
{
	/**
	 * Constants to allow joins to extra tables in certain queries
	 *
	 * @var integer Join user table to fetch avatar info of last poster
	 */
	const FETCH_WAINDIGO_LASTPOST_AVATAR = 0x01;

	public function prepareSocialForumFetchOptions(array $fetchOptions)
	{
	    $selectFields = '';
	    $joinTables = '';

	    if (isset($fetchOptions['join_waindigo'])) {
	        if ($fetchOptions['join_waindigo'] & self::FETCH_WAINDIGO_LASTPOST_AVATAR) {
	            $selectFields .= ',
					last_post_user.avatar_date AS last_post_user_avatar_date, last_post_user.gravatar AS last_post_user_gravatar';
	            $joinTables .= '
					LEFT JOIN xf_user AS last_post_user ON
						(last_post_user.user_id = social_forum.last_post_user_id)';
	        }
	    }

	    $socialForumFetchOptions = parent::prepareSocialForumFetchOptions($fetchOptions);

	    return array(
            'selectFields' => $selectFields . $socialForumFetchOptions['selectFields'],
            'joinTables' => $joinTables . $socialForumFetchOptions['joinTables'],
            'orderClause' => $socialForumFetchOptions['orderClause'],
	    );
	}
}