<?php

class Brivium_Credits_DataWriter_Discussion_Thread extends XFCP_Brivium_Credits_DataWriter_Discussion_Thread
{
	protected function _saveFirstMessageDw()
	{
		$response = parent::_saveFirstMessageDw();
		$threadId = $this->get('thread_id');
		if ($this->isInsert())
		{
			$creditModel = $this->_getCreditModel();
			// createNewThread
			$messageDw = $this->_firstMessageDw;
			$wordCount = $creditModel->calculateWordAmount(strtolower($messageDw->get('message')));
			$dataCredit = array(
				'node_id'		=>	$this->get('node_id'),
				'multiplier' 	=> 	$wordCount,
				'extraData' 	=>	array('thread_id'=>$this->get('thread_id'))
			);
			$creditModel->updateUserCredit('createNewThread',$this->get('user_id'),$dataCredit);
		}
		return $response;
	}
	protected function _discussionPostDelete(array $messages)
	{
		$creditModel = $this->_getCreditModel();
		// threadDeleted
		$wordCount = 0;
		if(isset($GLOBALS['BRC_DELETETHREAD_WORDCOUNT'])){
			$wordCount = $GLOBALS['BRC_DELETETHREAD_WORDCOUNT'] ;
		}
		$dataCredit = array(
			'node_id'		=>	$this->get('node_id'),
			'multiplier'	=>	$wordCount,
			'extraData' 	=>	array('node_id'=>$this->get('node_id'))
		);
		$creditModel->updateUserCredit('threadDeleted',$this->get('user_id'),$dataCredit);
		return parent::_discussionPostDelete($messages);
	}
	protected function _deleteDiscussionMessages(array $messages)
	{
		$creditModel = $this->_getCreditModel();
		$firstPost = $this->getModelFromCache('XenForo_Model_Post')->getPostById($this->get('first_post_id'));
		$wordCount = $creditModel->calculateWordAmount(strtolower($firstPost['message']));
		$GLOBALS['BRC_DELETETHREAD_WORDCOUNT'] = $wordCount;
		return parent::_deleteDiscussionMessages($messages);
	}
	
	protected function _discussionPostSave(array $messages)
	{
		// threadSticky
		if($this->isInsert() && $this->get('sticky')){
			$creditModel = $this->_getCreditModel();
			$dataCredit = array(
				'node_id'		=>	$this->get('node_id'),
				'extraData' 	=>	array('thread_id'=>$this->get('thread_id'))
			);
			$creditModel->updateUserCredit('threadSticky',$this->get('user_id'),$dataCredit);
		}else if ($this->isUpdate() && $this->isChanged('sticky')){
			$creditModel = $this->_getCreditModel();
			$dataCredit = array(
				'node_id'		=>	$this->get('node_id'),
				'extraData' 	=>	array('thread_id'=>$this->get('thread_id'))
			);
			if($this->get('sticky')){
				$creditModel->updateUserCredit('threadSticky',$this->get('user_id'),$dataCredit);
			}else{
				$dataCredit['reverted'] = true;
				$creditModel->updateUserCredit('threadSticky',$this->get('user_id'),$dataCredit);
			}
		}
		return parent::_discussionPostSave($messages);
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
	
}