<?php

class Brivium_Credits_ControllerPublic_Account extends XFCP_Brivium_Credits_ControllerPublic_Account
{
		## ------------------------------------------
	##
	## Browsing Preferences
	##

	/**
	 * Main user options editing control panel
	 *
	 * @return XenForo_ControllerResponse_View
	 */
	public function actionPreferences()
	{
		$response =  parent::actionPreferences();
		if(isset($response->subView->params)){
			$options = XenForo_Application::get('options');
			$currencyModel = $this->getModelFromCache('Brivium_Credits_Model_Currency');
			$currencies = $currencyModel->getActiveCurrencies();
			$defaultCurrency = isset($currencies[$options->BRC_defaultCurrencyId]) ? $currencies[$options->BRC_defaultCurrencyId] : array();
			$response->subView->params['defaultCurrency'] = $defaultCurrency;
			$response->subView->params['currencies'] = $currencies;
			$response->subView->params['canChangeCurrency'] = (count($currencies) > 1) && $options->BRC_userCanChangeCurrency;
		}
		return $response;
	}
	
	/**
	 * Save user options
	 *
	 * @return XenForo_ControllerResponse_Redirect
	 */
	public function actionPreferencesSave()
	{
		$currencyId = $this->_input->filterSingle('currency_id', XenForo_Input::UINT);
		$GLOBALS['BRC_CPA_actionPreferencesSave_currencyId'] = $currencyId;
		return parent::actionPreferencesSave();
	}
	
	## ------------------------------------------
	##
	## Alert preferences
	##

	public function actionAlertPreferences()
	{
		
		$response =  parent::actionAlertPreferences();
		if(isset($response->subView->params)){
			$actions = XenForo_Application::get('brcActions')->getActions();
			$actionModel = $this->_getActionModel();
			$actions = $actionModel->prepareActions($actions);
			$alertActions = array();
			
			foreach($actions AS $action){
				$action['checked'] = true;
				if(isset($response->subView->params['alertOptOuts']['credits_'.$action['action_id']])){
					$action['checked'] = false;
				}
				$alertActions['credits_'.$action['action_id']] = $action;
			}
			$response->subView->params['actions'] = $alertActions;
		}
		return $response;
	}
	
	## ------------------------------------------
	##
	## Personal Details
	##

	/**
	 * Save profile data
	 *
	 * @return XenForo_ControllerResponse_Redirect
	 */
	public function actionPersonalDetailsSave()
	{
		$GLOBALS['BRC_CPA_actionPersonalDetailsSave'] = $this;
		return parent::actionPersonalDetailsSave();
	}

	public function actionAvatarUpload()
	{
		$GLOBALS['BRC_CPA_actionPersonalDetailsSave'] = $this;
		return parent::actionAvatarUpload();
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Action
	 */
	protected function _getActionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Action');
	}
}